/*
 * Decompiled with CFR 0.152.
 */
package de.sanchofock.dsa.character;

import de.sanchofock.dsa.Play;
import de.sanchofock.dsa.character.CharacterGroup;
import de.sanchofock.dsa.tool.GameLog;
import de.sanchofock.dsa.tool.GlogConsole;
import de.sanchofock.dsa.types.ATResult;
import java.util.Random;

public class Fight {
    private CharacterGroup FPartyA = null;
    private CharacterGroup FPartyB = null;
    private GameLog log = null;

    public Fight(CharacterGroup _SideOne, CharacterGroup _sideTwo) {
        if (_SideOne.getMut() >= _sideTwo.getMut()) {
            this.FPartyA = _SideOne;
            this.FPartyB = _sideTwo;
        } else {
            this.FPartyB = _SideOne;
            this.FPartyA = _sideTwo;
        }
        this.log = Play.log;
        if (this.log == null) {
            this.log = new GlogConsole();
        }
    }

    public void go() {
        this.log.logFight(this.FPartyA, this.FPartyB);
        int roundNo = 1;
        while (!this.FPartyA.allDead() && !this.FPartyB.allDead()) {
            this.log.logNewFightRound(roundNo++);
            this.runFightRound();
        }
        if (this.FPartyA.allDead()) {
            this.log.logSurvivor(this.FPartyB);
        } else {
            this.log.logSurvivor(this.FPartyA);
        }
    }

    public void runFightRound() {
        this.fightRound(this.FPartyA, this.FPartyB);
        this.fightRound(this.FPartyB, this.FPartyA);
        this.FPartyA.nextKampfrunde();
        this.FPartyB.nextKampfrunde();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void fightRound(CharacterGroup _attakers, CharacterGroup _defenders) {
        int noEnemy = _defenders.getSize();
        int thisEnemy = 0;
        int tp = 0;
        boolean lastPA = true;
        ATResult resAT = null;
        Random w = new Random();
        int i = 0;
        while (i < _attakers.getSize()) {
            if (_attakers.getCharacter(i).isAlive()) {
                lastPA = true;
                thisEnemy = w.nextInt(noEnemy);
                resAT = _attakers.getCharacter(i).doAttake();
                if (resAT.gelungen()) {
                    if (resAT.isKritisch()) {
                        lastPA = false;
                        tp = _attakers.getCharacter(i).getTrefferpunkte();
                        _defenders.getCharacter(thisEnemy).trefferKassieren(true, tp);
                    } else if (!_defenders.getCharacter(thisEnemy).doParade()) {
                        lastPA = false;
                        tp = _attakers.getCharacter(i).getTrefferpunkte();
                        _defenders.getCharacter(thisEnemy).trefferKassieren(false, tp);
                    }
                }
                this.log.logAngriff(_attakers.getCharacter(i), _defenders.getCharacter(thisEnemy), resAT.gelungen(), lastPA, tp);
            }
            ++i;
        }
    }
}

