/*
 * Decompiled with CFR 0.152.
 */
package de.sanchofock.dsa;

import de.sanchofock.dsa.adventure.SoloAdventure;
import de.sanchofock.dsa.adventure.items.SAItem;
import de.sanchofock.dsa.adventure.items.actions.ItHeroAction;
import de.sanchofock.dsa.tool.GameLog;
import java.io.File;

public class Play {
    private SoloAdventure FAdv = null;
    private SAItem FcurItem = null;
    public static GameLog log = null;

    public Play(String _advFile, String _heroFile, GameLog _log) {
        log = _log;
        try {
            File advFile = new File(_advFile);
            File heroFile = new File(_heroFile);
            this.FAdv = new SoloAdventure();
            this.FAdv.readAdventureFile(advFile);
            this.FAdv.readHero(heroFile);
            this.FcurItem = this.FAdv.getFirstItem();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.FcurItem = null;
        }
    }

    public boolean canPlay() {
        return this.FcurItem != null & this.FAdv.readyToPlay();
    }

    public String gotoItem(String _itemKey) {
        if (this.FcurItem.getOptions().canGoTo(_itemKey)) {
            this.FcurItem = this.FAdv.getItem(_itemKey);
            while (this.FcurItem.isActionItem()) {
                ItHeroAction thisAction = (ItHeroAction)this.FcurItem;
                String nextItem = thisAction.doHeroAction(this.FAdv.getHero());
                this.FcurItem = this.FAdv.getItem(nextItem);
            }
            return this.FcurItem.getItemText();
        }
        return "Option nicht m\u00f6glich. " + this.FcurItem.getOptions().getOptionText();
    }

    public String getCurrentItemText() {
        return this.FcurItem.getItemText();
    }

    public boolean isFinished() {
        return this.FcurItem.getOptions().canGoTo("FIN");
    }

    public SAItem getCurItem() {
        return this.FcurItem;
    }

    public GameLog log() {
        return log;
    }

    public void saveHero(String _fileName) {
        this.FAdv.saveHero(_fileName);
    }

    public static void setGameLog(GameLog _log) {
        log = _log;
    }
}

