/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.stress;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.transform.TransformerException;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.examples.ss.ExcelComparator;
import org.apache.poi.examples.xssf.eventusermodel.FromHowTo;
import org.apache.poi.examples.xssf.eventusermodel.XLSX2CSV;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.ooxml.POIXMLException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OLE2NotOfficeXmlFileException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.crypt.Decryptor;
import org.apache.poi.poifs.crypt.EncryptionInfo;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.stress.POIXMLDocumentHandler;
import org.apache.poi.stress.SpreadsheetHandler;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.NullPrintStream;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.extractor.XSSFExportToXml;
import org.apache.poi.xssf.usermodel.XSSFMap;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.xml.sax.SAXException;

class XSSFFileHandler
extends SpreadsheetHandler {
    private static final Set<String> EXPECTED_ADDITIONAL_FAILURES = new HashSet<String>();

    XSSFFileHandler() {
    }

    @Override
    public void handleFile(InputStream stream, String path) throws Exception {
        String pass = Biff8EncryptionKey.getCurrentUserPassword();
        Assumptions.assumeFalse((pass == null && POIXMLDocumentHandler.isEncrypted(stream) ? 1 : 0) != 0);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy(stream, out);
        ByteArrayInputStream bytes = new ByteArrayInputStream(out.toByteArray());
        if (pass != null) {
            POIFSFileSystem poifs = new POIFSFileSystem(bytes);
            EncryptionInfo ei = new EncryptionInfo(poifs);
            Decryptor dec = ei.getDecryptor();
            try {
                boolean b = dec.verifyPassword(pass);
                Assertions.assertTrue((boolean)b, (String)"password mismatch");
            }
            catch (EncryptedDocumentException e) {
                String msg = "Export Restrictions in place - please install JCE Unlimited Strength Jurisdiction Policy files";
                Assumptions.assumeFalse((boolean)msg.equals(e.getMessage()));
                throw e;
            }
            InputStream is = dec.getDataStream(poifs);
            out.reset();
            IOUtils.copy(is, out);
            is.close();
            poifs.close();
            bytes = new ByteArrayInputStream(out.toByteArray());
        }
        this.checkXSSFReader(OPCPackage.open(bytes));
        bytes.reset();
        XSSFWorkbook wb = new XSSFWorkbook(bytes);
        this.handleWorkbook(wb);
        new POIXMLDocumentHandler().handlePOIXMLDocument(wb);
        this.exportToXML(wb);
        wb.close();
    }

    private void checkXSSFReader(OPCPackage p) throws IOException, OpenXML4JException {
        XSSFReader reader = new XSSFReader(p);
        InputStream sharedStringsData = reader.getSharedStringsData();
        if (sharedStringsData != null) {
            sharedStringsData.close();
        }
        reader.getSharedStringsTable();
        InputStream stylesData = reader.getStylesData();
        if (stylesData != null) {
            stylesData.close();
        }
        reader.getStylesTable();
        InputStream themesData = reader.getThemesData();
        if (themesData != null) {
            themesData.close();
        }
        Assertions.assertNotNull((Object)reader.getWorkbookData());
        Iterator<InputStream> sheetsData = reader.getSheetsData();
        while (sheetsData.hasNext()) {
            InputStream str = sheetsData.next();
            str.close();
        }
    }

    private void exportToXML(XSSFWorkbook wb) throws SAXException, TransformerException {
        for (XSSFMap map : wb.getCustomXMLMappings()) {
            XSSFExportToXml exporter = new XSSFExportToXml(map);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            exporter.exportToXML(os, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAdditional(File file) throws Exception {
        PrintStream oldOut = System.out;
        String testFile = file.getParentFile().getName() + "/" + file.getName();
        try {
            System.setOut((PrintStream)new NullPrintStream());
            FromHowTo.main(new String[]{file.getAbsolutePath()});
            XLSX2CSV.main(new String[]{file.getAbsolutePath()});
            ExcelComparator.main(new String[]{file.getAbsolutePath(), file.getAbsolutePath()});
            Assertions.assertFalse((boolean)EXPECTED_ADDITIONAL_FAILURES.contains(testFile), (String)("Expected Extraction to fail for file " + file + " and handler " + this + ", but did not fail!"));
        }
        catch (OLE2NotOfficeXmlFileException oLE2NotOfficeXmlFileException) {
        }
        catch (IOException | IllegalArgumentException | POIXMLException | InvalidFormatException e) {
            if (!EXPECTED_ADDITIONAL_FAILURES.contains(testFile)) {
                throw e;
            }
        }
        finally {
            System.setOut(oldOut);
        }
    }

    @Test
    void test() throws Exception {
        File file = new File("test-data/spreadsheet/ref-56737.xlsx");
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
            this.handleFile(stream, file.getPath());
        }
        this.handleExtracting(file);
    }

    @Test
    void testAdditional() throws Exception {
        this.handleAdditional(new File("test-data/spreadsheet/poc-xmlbomb.xlsx"));
    }

    static {
        EXPECTED_ADDITIONAL_FAILURES.add("spreadsheet/54764.xlsx");
        EXPECTED_ADDITIONAL_FAILURES.add("spreadsheet/54764-2.xlsx");
        EXPECTED_ADDITIONAL_FAILURES.add("spreadsheet/poc-xmlbomb.xlsx");
        EXPECTED_ADDITIONAL_FAILURES.add("spreadsheet/poc-xmlbomb-empty.xlsx");
        EXPECTED_ADDITIONAL_FAILURES.add("spreadsheet/57914.xlsx");
        EXPECTED_ADDITIONAL_FAILURES.add("spreadsheet/SampleSS.strict.xlsx");
        EXPECTED_ADDITIONAL_FAILURES.add("spreadsheet/SimpleStrict.xlsx");
        EXPECTED_ADDITIONAL_FAILURES.add("spreadsheet/sample.strict.xlsx");
        EXPECTED_ADDITIONAL_FAILURES.add("spreadsheet/sample-beta.xlsx");
        EXPECTED_ADDITIONAL_FAILURES.add("openxml4j/invalid.xlsx");
    }
}

