/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.stress;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.poi.OldFileFormatException;
import org.apache.poi.hssf.record.crypto.Biff8EncryptionKey;
import org.apache.poi.stress.AbstractFileHandler;
import org.apache.poi.stress.FileHandler;
import org.apache.poi.stress.HDGFFileHandler;
import org.apache.poi.stress.HMEFFileHandler;
import org.apache.poi.stress.HPBFFileHandler;
import org.apache.poi.stress.HPSFFileHandler;
import org.apache.poi.stress.HSLFFileHandler;
import org.apache.poi.stress.HSMFFileHandler;
import org.apache.poi.stress.HSSFFileHandler;
import org.apache.poi.stress.HWPFFileHandler;
import org.apache.poi.stress.OPCFileHandler;
import org.apache.poi.stress.POIFSFileHandler;
import org.apache.poi.stress.XDGFFileHandler;
import org.apache.poi.stress.XSLFFileHandler;
import org.apache.poi.stress.XSSFBFileHandler;
import org.apache.poi.stress.XSSFFileHandler;
import org.apache.poi.stress.XWPFFileHandler;
import org.apache.tools.ant.DirectoryScanner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.opentest4j.TestAbortedException;

class TestAllFiles {
    private static final File ROOT_DIR = new File("test-data");
    private static final boolean IGNORE_SCRATCHPAD = Boolean.getBoolean("scratchpad.ignore");
    public static final String[] SCAN_EXCLUDES = new String[]{"**/.svn/**", "lost+found", "**/.git/**"};
    private static final Map<String, String> FILE_PASSWORD;
    public static final Map<String, FileHandler> HANDLERS;
    private static final Set<String> OLD_FILES_HWPF;
    private static final Set<String> EXPECTED_FAILURES;
    private static final Set<String> IGNORED;

    TestAllFiles() {
    }

    private static Set<String> unmodifiableHashSet(String ... a) {
        return Collections.unmodifiableSet(TestAllFiles.hashSet(a));
    }

    private static Set<String> hashSet(String ... a) {
        return new HashSet<String>(Arrays.asList(a));
    }

    public static Stream<Arguments> files() {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(ROOT_DIR);
        scanner.setExcludes(SCAN_EXCLUDES);
        scanner.scan();
        System.out.println("Handling " + scanner.getIncludedFiles().length + " files");
        ArrayList<Arguments> files = new ArrayList<Arguments>();
        for (String file : scanner.getIncludedFiles()) {
            if (IGNORED.contains(file = file.replace('\\', '/'))) {
                System.out.println("Ignoring " + file);
                continue;
            }
            FileHandler handler = HANDLERS.get(TestAllFiles.getExtension(file));
            files.add(Arguments.of((Object[])new Object[]{file, handler}));
            if (handler instanceof XSSFFileHandler || handler instanceof XWPFFileHandler || handler instanceof XSLFFileHandler || handler instanceof XDGFFileHandler) {
                files.add(Arguments.of((Object[])new Object[]{file, new OPCFileHandler()}));
            }
            if (!(handler instanceof HSSFFileHandler) && !(handler instanceof HSLFFileHandler) && !(handler instanceof HWPFFileHandler) && !(handler instanceof HDGFFileHandler)) continue;
            files.add(Arguments.of((Object[])new Object[]{file, new HPSFFileHandler()}));
        }
        return files.stream();
    }

    @ParameterizedTest(name="#{index} {0}")
    @MethodSource(value={"files"})
    void testAllFiles(String file, FileHandler handler) throws Exception {
        block24: {
            File inputFile;
            block23: {
                Assertions.assertNotNull((Object)handler, (String)("Did not find a handler for file " + file));
                String pass = FILE_PASSWORD.get(file);
                Biff8EncryptionKey.setCurrentUserPassword(pass);
                System.out.println("Reading " + file + " with " + handler.getClass().getSimpleName());
                Assertions.assertNotNull((Object)handler, (String)("Unknown file extension for file: " + file + ": " + TestAllFiles.getExtension(file)));
                inputFile = new File(ROOT_DIR, file);
                boolean ignoredOPC = (file.endsWith(".docx") || file.endsWith(".xlsx") || file.endsWith(".xlsb") || file.endsWith(".pptx")) && handler instanceof OPCFileHandler;
                boolean ignoreHPSF = handler instanceof HPSFFileHandler;
                try {
                    try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(inputFile), 65536);){
                        handler.handleFile(stream, file);
                        Assertions.assertFalse((OLD_FILES_HWPF.contains(file) && !ignoreHPSF ? 1 : 0) != 0, (String)("Expected to fail for file " + file + " and handler " + handler + ", but did not fail!"));
                    }
                    handler.handleExtracting(inputFile);
                    Assertions.assertFalse((EXPECTED_FAILURES.contains(file) && !ignoredOPC && !ignoreHPSF ? 1 : 0) != 0, (String)("Expected to fail for file " + file + " and handler " + handler + ", but did not fail!"));
                }
                catch (OldFileFormatException e) {
                    if (OLD_FILES_HWPF.contains(file)) {
                        handler.handleExtracting(inputFile);
                    } else if (!EXPECTED_FAILURES.contains(file) && !AbstractFileHandler.EXPECTED_EXTRACTOR_FAILURES.contains(file)) {
                        System.out.println("Failed: " + file);
                        throw new Exception("While handling " + file, e);
                    }
                }
                catch (TestAbortedException e) {
                }
                catch (Exception e) {
                    if (EXPECTED_FAILURES.contains(file) || AbstractFileHandler.EXPECTED_EXTRACTOR_FAILURES.contains(file)) break block23;
                    System.out.println("Failed: " + file);
                    throw new Exception("While handling " + file, e);
                }
            }
            try {
                handler.handleAdditional(inputFile);
            }
            catch (TestAbortedException e) {
            }
            catch (Exception e) {
                if (EXPECTED_FAILURES.contains(file) || AbstractFileHandler.EXPECTED_EXTRACTOR_FAILURES.contains(file)) break block24;
                System.out.println("Failed: " + file);
                throw new Exception("While handling " + file, e);
            }
        }
    }

    public static String getExtension(String file) {
        int pos = file.lastIndexOf(46);
        if (pos == -1 || pos == file.length() - 1) {
            return file;
        }
        return file.substring(pos).toLowerCase(Locale.ROOT);
    }

    static {
        HANDLERS = new HashMap<String, FileHandler>();
        HANDLERS.put(".xls", new HSSFFileHandler());
        HANDLERS.put(".xlsx", new XSSFFileHandler());
        HANDLERS.put(".xlsm", new XSSFFileHandler());
        HANDLERS.put(".xltx", new XSSFFileHandler());
        HANDLERS.put(".xlsb", new XSSFBFileHandler());
        HANDLERS.put(".doc", IGNORE_SCRATCHPAD ? new HPSFFileHandler() : new HWPFFileHandler());
        HANDLERS.put(".docx", new XWPFFileHandler());
        HANDLERS.put(".dotx", new XWPFFileHandler());
        HANDLERS.put(".docm", new XWPFFileHandler());
        HANDLERS.put(".ooxml", new OPCFileHandler());
        HANDLERS.put(".zip", new OPCFileHandler());
        HANDLERS.put(".ppt", IGNORE_SCRATCHPAD ? new HPSFFileHandler() : new HSLFFileHandler());
        HANDLERS.put(".pot", IGNORE_SCRATCHPAD ? new HPSFFileHandler() : new HSLFFileHandler());
        HANDLERS.put(".pptx", new XSLFFileHandler());
        HANDLERS.put(".pptm", new XSLFFileHandler());
        HANDLERS.put(".ppsm", new XSLFFileHandler());
        HANDLERS.put(".ppsx", new XSLFFileHandler());
        HANDLERS.put(".thmx", new XSLFFileHandler());
        HANDLERS.put(".potx", new XSLFFileHandler());
        HANDLERS.put(".msg", IGNORE_SCRATCHPAD ? new HPSFFileHandler() : new HSMFFileHandler());
        HANDLERS.put(".pub", IGNORE_SCRATCHPAD ? new HPSFFileHandler() : new HPBFFileHandler());
        HANDLERS.put(".vsd", IGNORE_SCRATCHPAD ? new HPSFFileHandler() : new HDGFFileHandler());
        HANDLERS.put(".vsdm", new XDGFFileHandler());
        HANDLERS.put(".vsdx", new XDGFFileHandler());
        HANDLERS.put(".vssm", new XDGFFileHandler());
        HANDLERS.put(".vssx", new XDGFFileHandler());
        HANDLERS.put(".vstm", new XDGFFileHandler());
        HANDLERS.put(".vstx", new XDGFFileHandler());
        HANDLERS.put(".vst", NullFileHandler.instance);
        HANDLERS.put(".vss", NullFileHandler.instance);
        HANDLERS.put(".ole2", new POIFSFileHandler());
        HANDLERS.put(".adm", new HPSFFileHandler());
        HANDLERS.put(".dat", IGNORE_SCRATCHPAD ? new HPSFFileHandler() : new HMEFFileHandler());
        HANDLERS.put(".wri", NullFileHandler.instance);
        HANDLERS.put(".shw", NullFileHandler.instance);
        HANDLERS.put(".zvi", NullFileHandler.instance);
        HANDLERS.put(".mpp", NullFileHandler.instance);
        HANDLERS.put(".qwp", NullFileHandler.instance);
        HANDLERS.put(".wps", NullFileHandler.instance);
        HANDLERS.put(".bin", NullFileHandler.instance);
        HANDLERS.put(".xps", NullFileHandler.instance);
        HANDLERS.put(".sldprt", NullFileHandler.instance);
        HANDLERS.put(".mdb", NullFileHandler.instance);
        HANDLERS.put(".vml", NullFileHandler.instance);
        HANDLERS.put(".txt", NullFileHandler.instance);
        HANDLERS.put(".pdf", NullFileHandler.instance);
        HANDLERS.put(".rtf", NullFileHandler.instance);
        HANDLERS.put(".gif", NullFileHandler.instance);
        HANDLERS.put(".html", NullFileHandler.instance);
        HANDLERS.put(".png", NullFileHandler.instance);
        HANDLERS.put(".wmf", NullFileHandler.instance);
        HANDLERS.put(".emf", NullFileHandler.instance);
        HANDLERS.put(".dib", NullFileHandler.instance);
        HANDLERS.put(".svg", NullFileHandler.instance);
        HANDLERS.put(".pict", NullFileHandler.instance);
        HANDLERS.put(".jpg", NullFileHandler.instance);
        HANDLERS.put(".jpeg", NullFileHandler.instance);
        HANDLERS.put(".tif", NullFileHandler.instance);
        HANDLERS.put(".tiff", NullFileHandler.instance);
        HANDLERS.put(".wav", NullFileHandler.instance);
        HANDLERS.put(".xml", NullFileHandler.instance);
        HANDLERS.put(".csv", NullFileHandler.instance);
        HANDLERS.put(".ods", NullFileHandler.instance);
        HANDLERS.put(".ttf", NullFileHandler.instance);
        HANDLERS.put(".fntdata", NullFileHandler.instance);
        HANDLERS.put(".vba", NullFileHandler.instance);
        HANDLERS.put(".bas", NullFileHandler.instance);
        HANDLERS.put(".frm", NullFileHandler.instance);
        HANDLERS.put(".frx", NullFileHandler.instance);
        HANDLERS.put(".cls", NullFileHandler.instance);
        HANDLERS.put("spreadsheet/BigSSTRecord", NullFileHandler.instance);
        HANDLERS.put("spreadsheet/BigSSTRecord2", NullFileHandler.instance);
        HANDLERS.put("spreadsheet/BigSSTRecord2CR1", NullFileHandler.instance);
        HANDLERS.put("spreadsheet/BigSSTRecord2CR2", NullFileHandler.instance);
        HANDLERS.put("spreadsheet/BigSSTRecord2CR3", NullFileHandler.instance);
        HANDLERS.put("spreadsheet/BigSSTRecord2CR4", NullFileHandler.instance);
        HANDLERS.put("spreadsheet/BigSSTRecord2CR5", NullFileHandler.instance);
        HANDLERS.put("spreadsheet/BigSSTRecord2CR6", NullFileHandler.instance);
        HANDLERS.put("spreadsheet/BigSSTRecord2CR7", NullFileHandler.instance);
        HANDLERS.put("spreadsheet/BigSSTRecordCR", NullFileHandler.instance);
        HANDLERS.put("spreadsheet/test_properties1", NullFileHandler.instance);
        HANDLERS.put(".pfx", NullFileHandler.instance);
        HANDLERS.put(".pem", NullFileHandler.instance);
        HANDLERS.put(".jks", NullFileHandler.instance);
        HANDLERS.put(".pkcs12", NullFileHandler.instance);
        HashMap<String, String> passmap = new HashMap<String, String>();
        passmap.put("slideshow/Password_Protected-hello.ppt", "hello");
        passmap.put("slideshow/Password_Protected-56-hello.ppt", "hello");
        passmap.put("slideshow/Password_Protected-np-hello.ppt", "hello");
        passmap.put("slideshow/cryptoapi-proc2356.ppt", "crypto");
        passmap.put("spreadsheet/xor-encryption-abc.xls", "abc");
        passmap.put("spreadsheet/35897-type4.xls", "freedom");
        passmap.put("spreadsheet/58616.xlsx", "VelvetSweatshop");
        passmap.put("spreadsheet/password.xls", "password");
        passmap.put("spreadsheet/protected_passtika.xlsx", "tika");
        passmap.put("document/bug53475-password-is-pass.docx", "pass");
        passmap.put("document/bug53475-password-is-solrcell.docx", "solrcell");
        passmap.put("document/password_password_cryptoapi.doc", "password");
        passmap.put("document/password_tika_binaryrc4.doc", "tika");
        passmap.put("poifs/protect.xlsx", "VelvetSweatshop");
        passmap.put("poifs/extenxls_pwd123.xlsx", "pwd123");
        passmap.put("poifs/protected_agile.docx", "VelvetSweatshop");
        passmap.put("poifs/60320-protected.xlsx", "Test001!!");
        passmap.put("poifs/protected_sha512.xlsx", "this is a test");
        FILE_PASSWORD = Collections.unmodifiableMap(passmap);
        OLD_FILES_HWPF = TestAllFiles.unmodifiableHashSet("document/Bug49933.doc", "document/Bug51944.doc", "document/Word6.doc", "document/Word6_sections.doc", "document/Word6_sections2.doc", "document/Word95.doc", "document/word95err.doc", "document/Bug60936.doc", "document/Bug60942.doc", "document/Bug60942b.doc", "document/cn.orthodox.www_divenbog_APRIL_30-APRIL.DOC", "hpsf/TestMickey.doc", "document/52117.doc", "hpsf/TestInvertedClassID.doc", "hpsf/TestBug52117.doc");
        EXPECTED_FAILURES = TestAllFiles.unmodifiableHashSet("spreadsheet/51832.xls", "spreadsheet/64759.xlsx", "document/PasswordProtected.doc", "spreadsheet/CustomXMLMapping-singleattributenamespace.xlsx", "spreadsheet/55864.xlsx", "spreadsheet/57890.xlsx", "spreadsheet/xxe_in_schema.xlsx", "spreadsheet/44958.xls", "spreadsheet/44958_1.xls", "spreadsheet/testArraysAndTables.xls", "spreadsheet/sample-beta.xlsx", "document/cpansearch.perl.org_src_tobyink_acme-rundoc-0.001_word-lib_hello_world.docm", "hpsf/TestRobert_Flaherty.doc", "spreadsheet/43493.xls", "spreadsheet/46904.xls", "document/Bug50955.doc", "document/57843.doc", "slideshow/PPT95.ppt", "slideshow/pp40only.ppt", "slideshow/Divino_Revelado.pptx", "openxml4j/OPCCompliance_CoreProperties_DCTermsNamespaceLimitedUseFAIL.docx", "openxml4j/OPCCompliance_CoreProperties_DoNotUseCompatibilityMarkupFAIL.docx", "openxml4j/OPCCompliance_CoreProperties_LimitedXSITypeAttribute_NotPresentFAIL.docx", "openxml4j/OPCCompliance_CoreProperties_LimitedXSITypeAttribute_PresentWithUnauthorizedValueFAIL.docx", "openxml4j/OPCCompliance_CoreProperties_OnlyOneCorePropertiesPartFAIL.docx", "openxml4j/OPCCompliance_CoreProperties_UnauthorizedXMLLangAttributeFAIL.docx", "openxml4j/OPCCompliance_DerivedPartNameFAIL.docx", "openxml4j/invalid.xlsx", "openxml4j/62592.thmx", "spreadsheet/54764-2.xlsx", "spreadsheet/54764.xlsx", "poifs/unknown_properties.msg", "poifs/only-zero-byte-streams.ole2", "spreadsheet/poc-xmlbomb.xlsx", "spreadsheet/poc-xmlbomb-empty.xlsx", "spreadsheet/poc-shared-strings.xlsx", "document/61612a.docx", "document/word2.doc", "spreadsheet/xlsx-corrupted.xlsx", "integration/stress025.docx", "spreadsheet/testEXCEL_2.xls", "spreadsheet/testEXCEL_3.xls", "spreadsheet/testEXCEL_4.xls", "spreadsheet/testEXCEL_5.xls", "spreadsheet/testEXCEL_95.xls", "spreadsheet/59074.xls", "spreadsheet/60284.xls", "spreadsheet/64130.xls", "spreadsheet/SampleSS.strict.xlsx", "spreadsheet/SimpleStrict.xlsx", "spreadsheet/sample.strict.xlsx", "spreadsheet/57914.xlsx", "openxml4j/ContentTypeHasEntities.ooxml", "ddf/Container.dat", "ddf/47143.dat", "spreadsheet/56450.xls", "hsmf/ASCII_CP1251_LCID1049.msg", "hsmf/ASCII_UTF-8_CP1252_LCID1031.msg", "hsmf/ASCII_UTF-8_CP1252_LCID1031_HTML.msg", "hsmf/HTMLBodyBinary_CP1251.msg", "hsmf/HTMLBodyBinary_UTF-8.msg");
        IGNORED = TestAllFiles.unmodifiableHashSet("spreadsheet/57181.xlsm", "spreadsheet/61300.xls");
    }

    public static class NullFileHandler
    implements FileHandler {
        public static final FileHandler instance = new NullFileHandler();

        @Override
        public void handleFile(InputStream stream, String path) {
        }

        @Override
        public void handleExtracting(File file) {
        }

        @Override
        public void handleAdditional(File file) {
        }
    }
}

