/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.stress;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.poi.ss.extractor.EmbeddedData;
import org.apache.poi.ss.extractor.EmbeddedExtractor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.stress.AbstractFileHandler;
import org.apache.poi.util.RecordFormatException;
import org.apache.poi.xssf.usermodel.XSSFChartSheet;
import org.junit.jupiter.api.Assertions;

public abstract class SpreadsheetHandler
extends AbstractFileHandler {
    public void handleWorkbook(Workbook wb) throws IOException {
        this.readContent(wb);
        this.writeToArray(wb);
        this.readContent(wb);
        ByteArrayOutputStream out = this.writeToArray(wb);
        Workbook read = WorkbookFactory.create(new ByteArrayInputStream(out.toByteArray()));
        Assertions.assertNotNull((Object)read);
        this.readContent(read);
        this.extractEmbedded(read);
        this.modifyContent(read);
        read.close();
    }

    private ByteArrayOutputStream writeToArray(Workbook wb) throws IOException {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            wb.write(stream);
        }
        return stream;
    }

    private void readContent(Workbook wb) {
        for (int i = 0; i < wb.getNumberOfSheets(); ++i) {
            Sheet sheet = wb.getSheetAt(i);
            Assertions.assertNotNull((Object)wb.getSheet(sheet.getSheetName()));
            sheet.groupColumn(4, 5);
            sheet.setColumnGroupCollapsed(4, true);
            sheet.setColumnGroupCollapsed(4, false);
            if (sheet.getPhysicalNumberOfRows() > 1000) continue;
            for (Row row : sheet) {
                for (Cell cell : row) {
                    Assertions.assertNotNull((Object)cell.toString());
                }
            }
        }
        for (Name name : wb.getAllNames()) {
            if (name.isFunctionName()) continue;
            name.getRefersToFormula();
        }
    }

    private void extractEmbedded(Workbook wb) throws IOException {
        EmbeddedExtractor ee = new EmbeddedExtractor();
        for (Sheet s : wb) {
            for (EmbeddedData ed : ee.extractAll(s)) {
                Assertions.assertNotNull((Object)ed.getFilename());
                Assertions.assertNotNull((Object)ed.getEmbeddedData());
                Assertions.assertNotNull((Object)ed.getShape());
            }
        }
    }

    private void modifyContent(Workbook wb) {
        for (int i = wb.getNumberOfSheets() - 1; i >= 0; --i) {
            if (wb.getSheetAt(i) instanceof XSSFChartSheet) continue;
            try {
                wb.cloneSheet(i);
                continue;
            }
            catch (RecordFormatException e) {
                if (e.getCause() instanceof CloneNotSupportedException) continue;
                throw e;
            }
            catch (RuntimeException e) {
                if ("Could not find 'internal references' EXTERNALBOOK".equals(e.getMessage()) || "CountryRecord not found".equals(e.getMessage()) || "CountryRecord or SSTRecord not found".equals(e.getMessage()) || "Cannot add more than 65535 shapes".equals(e.getMessage())) continue;
                throw e;
            }
        }
    }
}

