/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.stress;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import org.apache.poi.sl.draw.Drawable;
import org.apache.poi.sl.usermodel.GroupShape;
import org.apache.poi.sl.usermodel.Notes;
import org.apache.poi.sl.usermodel.PictureData;
import org.apache.poi.sl.usermodel.Shape;
import org.apache.poi.sl.usermodel.SimpleShape;
import org.apache.poi.sl.usermodel.Slide;
import org.apache.poi.sl.usermodel.SlideShow;
import org.apache.poi.sl.usermodel.SlideShowFactory;
import org.apache.poi.sl.usermodel.TextParagraph;
import org.apache.poi.sl.usermodel.TextRun;
import org.apache.poi.sl.usermodel.TextShape;
import org.apache.poi.stress.POIFSFileHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.platform.commons.util.ExceptionUtils;

public abstract class SlideShowHandler
extends POIFSFileHandler {
    public void handleSlideShow(SlideShow<?, ?> ss) throws IOException {
        this.renderSlides(ss);
        this.readContent(ss);
        this.readPictures(ss);
        ByteArrayOutputStream out = this.writeToArray(ss);
        this.readContent(ss);
        try (SlideShow<?, ?> read = SlideShowFactory.create(new ByteArrayInputStream(out.toByteArray()));){
            Assertions.assertNotNull(read);
            this.readContent(read);
        }
    }

    private ByteArrayOutputStream writeToArray(SlideShow<?, ?> ss) throws IOException {
        try (ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            ss.write(stream);
        }
        return stream;
    }

    private void readContent(SlideShow<?, ?> ss) {
        for (Slide<?, ?> s : ss.getSlides()) {
            s.getTitle();
            for (Shape shape : s) {
                this.readShapes(shape);
            }
            Notes<?, ?> notes = s.getNotes();
            if (notes != null) {
                for (Shape shape : notes) {
                    this.readShapes(shape);
                }
            }
            for (Shape shape : s.getMasterSheet()) {
                this.readShapes(shape);
            }
        }
    }

    private void readShapes(Shape<?, ?> s) {
        if (s instanceof GroupShape) {
            GroupShape shapes = (GroupShape)s;
            for (Shape shape : shapes) {
                this.readShapes(shape);
            }
        }
        if (s instanceof SimpleShape) {
            SimpleShape simpleShape = (SimpleShape)s;
            simpleShape.getFillColor();
            simpleShape.getFillStyle();
            simpleShape.getStrokeStyle();
            simpleShape.getLineDecoration();
        }
        this.readText(s);
    }

    private void readText(Shape<?, ?> s) {
        if (s instanceof TextShape) {
            for (TextParagraph tp : (TextShape)s) {
                for (TextRun tr : tp) {
                    tr.getRawText();
                }
            }
        }
    }

    private void readPictures(SlideShow<?, ?> ss) {
        for (PictureData pd : ss.getPictureData()) {
            Dimension dim = pd.getImageDimension();
            Assertions.assertTrue((dim.getHeight() >= 0.0 ? 1 : 0) != 0, (String)("Expecting a valid height, but had an image with height: " + dim.getHeight()));
            Assertions.assertTrue((dim.getWidth() >= 0.0 ? 1 : 0) != 0, (String)("Expecting a valid width, but had an image with width: " + dim.getWidth()));
        }
    }

    private void renderSlides(SlideShow<?, ?> ss) {
        Dimension pgSize = ss.getPageSize();
        for (Slide<?, ?> s : ss.getSlides()) {
            BufferedImage img = new BufferedImage(pgSize.width, pgSize.height, 2);
            Graphics2D graphics = img.createGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            graphics.setRenderingHint(Drawable.BUFFERED_IMAGE, new WeakReference<BufferedImage>(img));
            try {
                s.draw(graphics);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                Assumptions.assumeFalse((e.getMessage().equals("-1") && ExceptionUtils.readStackTrace((Throwable)e).contains("ExtendedTextSourceLabel.getJustificationInfos") ? 1 : 0) != 0, (String)("JDK sometimes fails at this point on some fonts on Windows machines, but we should not fail the build because of this: " + ExceptionUtils.readStackTrace((Throwable)e)));
                throw e;
            }
            graphics.dispose();
            img.flush();
        }
    }
}

