/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.stress;

import java.io.File;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.poi.stress.FileHandler;
import org.apache.poi.stress.TestAllFiles;
import org.apache.poi.stress.XSSFFileHandler;
import org.apache.poi.util.SuppressForbidden;
import org.apache.tools.ant.DirectoryScanner;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

class POIFileScanner {
    private static final File ROOT_DIR = new File("../../test-data").exists() ? new File("../../test-data") : new File("test-data");

    POIFileScanner() {
    }

    public static Collection<Map.Entry<String, FileHandler>> scan(File rootDir) throws IOException {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(rootDir);
        scanner.setExcludes(TestAllFiles.SCAN_EXCLUDES);
        System.out.println("Scanning for files in " + rootDir);
        scanner.scan();
        String[] includedFiles = scanner.getIncludedFiles();
        System.out.println("Handling " + includedFiles.length + " files");
        ArrayList<Map.Entry<String, FileHandler>> files = new ArrayList<Map.Entry<String, FileHandler>>();
        for (String file : includedFiles) {
            FileHandler fileHandler = POIFileScanner.getFileHandler(rootDir, file);
            files.add(new AbstractMap.SimpleImmutableEntry<String, FileHandler>(file, fileHandler));
            if (files.size() % 100 != 0) continue;
            System.out.print(".");
            if (files.size() % 100000 != 0) continue;
            System.out.println(file);
        }
        System.out.println();
        return files;
    }

    protected static FileHandler getFileHandler(File rootDir, String file) throws IOException {
        FileHandler fileHandler = TestAllFiles.HANDLERS.get(TestAllFiles.getExtension(file));
        if (fileHandler == null) {
            fileHandler = POIFileScanner.detectUnnamedFile(rootDir, file);
        }
        return fileHandler;
    }

    /*
     * Exception decompiling
     */
    private static FileHandler detectUnnamedFile(File rootDir, String file) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Disabled
    @Test
    @SuppressForbidden(value="Just an ignored test")
    void testInvalidFile() throws IOException, InterruptedException {
        FileHandler fileHandler = POIFileScanner.getFileHandler(new File("/usbc/CommonCrawl"), "www.bgs.ac.uk_downloads_directdownload.cfm_id=2362&noexcl=true&t=west_20sussex_20-_20building_20stone_20quarries");
        Assertions.assertEquals(XSSFFileHandler.class, fileHandler.getClass());
        System.gc();
        Thread.sleep(1000L);
        System.gc();
        Thread.sleep(1000L);
    }

    @Test
    void testDetectUnnamedFile() throws IOException {
        File root = new File(ROOT_DIR, "spreadsheet");
        Assertions.assertDoesNotThrow(() -> POIFileScanner.detectUnnamedFile(root, "49156.xlsx"));
    }

    @Test
    void test() throws IOException {
        Assertions.assertDoesNotThrow(() -> POIFileScanner.scan(ROOT_DIR));
    }
}

