/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.stress;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.Set;
import org.apache.poi.hssf.OldExcelFormatException;
import org.apache.poi.hssf.dev.BiffViewer;
import org.apache.poi.hssf.usermodel.HSSFOptimiser;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.stress.POIFSFileHandler;
import org.apache.poi.stress.SpreadsheetHandler;
import org.apache.poi.util.NullPrintStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HSSFFileHandler
extends SpreadsheetHandler {
    private final POIFSFileHandler delegate = new POIFSFileHandler();
    private static final Set<String> EXPECTED_ADDITIONAL_FAILURES = new HashSet<String>();

    HSSFFileHandler() {
    }

    @Override
    public void handleFile(InputStream stream, String path) throws Exception {
        HSSFWorkbook wb = new HSSFWorkbook(stream);
        this.handleWorkbook(wb);
        this.delegate.handlePOIDocument(wb);
        HSSFOptimiser.optimiseCellStyles(wb);
        for (Sheet sheet : wb) {
            for (Row row : sheet) {
                for (Cell cell : row) {
                    Assertions.assertNotNull((Object)cell.getCellStyle());
                }
            }
        }
        HSSFOptimiser.optimiseFonts(wb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAdditional(File file) throws Exception {
        PrintStream oldOut = System.out;
        String fileWithParent = file.getParentFile().getName() + "/" + file.getName();
        try {
            System.setOut((PrintStream)new NullPrintStream());
            BiffViewer.main(new String[]{file.getAbsolutePath()});
            Assertions.assertFalse((boolean)EXPECTED_ADDITIONAL_FAILURES.contains(fileWithParent), (String)("Expected Extraction to fail for file " + file + " and handler " + this + ", but did not fail!"));
        }
        catch (OldExcelFormatException oldExcelFormatException) {
        }
        catch (RuntimeException e) {
            if (!EXPECTED_ADDITIONAL_FAILURES.contains(fileWithParent)) {
                throw e;
            }
        }
        finally {
            System.setOut(oldOut);
        }
    }

    @Test
    void test() throws Exception {
        File file = new File("test-data/spreadsheet/49219.xls");
        try (FileInputStream stream = new FileInputStream(file);){
            this.handleFile(stream, file.getPath());
        }
        this.handleExtracting(file);
        this.handleAdditional(file);
    }

    @Test
    void testExtractor() throws Exception {
        this.handleExtracting(new File("test-data/spreadsheet/BOOK_in_capitals.xls"));
    }

    static {
        EXPECTED_ADDITIONAL_FAILURES.add("spreadsheet/35897-type4.xls");
        EXPECTED_ADDITIONAL_FAILURES.add("spreadsheet/xor-encryption-abc.xls");
        EXPECTED_ADDITIONAL_FAILURES.add("spreadsheet/password.xls");
        EXPECTED_ADDITIONAL_FAILURES.add("spreadsheet/43493.xls");
        EXPECTED_ADDITIONAL_FAILURES.add("spreadsheet/50833.xls");
        EXPECTED_ADDITIONAL_FAILURES.add("spreadsheet/51832.xls");
        EXPECTED_ADDITIONAL_FAILURES.add("spreadsheet/XRefCalc.xls");
        EXPECTED_ADDITIONAL_FAILURES.add("spreadsheet/61300.xls");
    }
}

