/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.stress;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.poi.hsmf.MAPIMessage;
import org.apache.poi.hsmf.datatypes.AttachmentChunks;
import org.apache.poi.hsmf.datatypes.DirectoryChunk;
import org.apache.poi.stress.POIFSFileHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HSMFFileHandler
extends POIFSFileHandler {
    HSMFFileHandler() {
    }

    @Override
    public void handleFile(InputStream stream, String path) throws Exception {
        AttachmentChunks[] attachments;
        MAPIMessage mapi = new MAPIMessage(stream);
        Assertions.assertNotNull((Object)mapi.getAttachmentFiles());
        Assertions.assertNotNull((Object)mapi.getDisplayBCC());
        Assertions.assertNotNull((Object)mapi.getMessageDate());
        for (AttachmentChunks attachment : attachments = mapi.getAttachmentFiles()) {
            DirectoryChunk chunkDirectory = attachment.getAttachmentDirectory();
            if (chunkDirectory == null) continue;
            MAPIMessage attachmentMSG = chunkDirectory.getAsEmbeddedMessage();
            Assertions.assertNotNull((Object)attachmentMSG);
            String body = attachmentMSG.getTextBody();
            Assertions.assertNotNull((Object)body);
        }
        mapi.close();
    }

    @Override
    @Test
    void test() throws Exception {
        File file = new File("test-data/hsmf/logsat.com_signatures_valid.msg");
        try (FileInputStream stream = new FileInputStream(file);){
            this.handleFile(stream, file.getPath());
        }
        this.handleExtracting(file);
    }
}

