/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.stress;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.poi.examples.hpsf.CopyCompare;
import org.apache.poi.hpsf.DocumentSummaryInformation;
import org.apache.poi.hpsf.HPSFPropertiesOnlyDocument;
import org.apache.poi.hpsf.PropertySet;
import org.apache.poi.hpsf.SummaryInformation;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.stress.POIFSFileHandler;
import org.apache.poi.util.TempFile;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.Test;

class HPSFFileHandler
extends POIFSFileHandler {
    private static final String NL = System.getProperty("line.separator");
    private static File copyOutput;
    static final Set<String> EXCLUDES_HANDLE_ADD;
    static final Set<String> EXCLUDES_HANDLE_FILE;

    HPSFFileHandler() {
    }

    private static Set<String> unmodifiableHashSet(String ... a) {
        return Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(a)));
    }

    @Override
    public void handleFile(InputStream stream, String path) throws Exception {
        Assumptions.assumeFalse((boolean)EXCLUDES_HANDLE_FILE.contains(path));
        POIFSFileSystem poifs = new POIFSFileSystem(stream);
        HPSFPropertiesOnlyDocument hpsf = new HPSFPropertiesOnlyDocument(poifs);
        DocumentSummaryInformation dsi = hpsf.getDocumentSummaryInformation();
        SummaryInformation si = hpsf.getSummaryInformation();
        boolean hasDSI = HPSFFileHandler.hasPropertyStream(poifs, "\u0005DocumentSummaryInformation");
        boolean hasSI = HPSFFileHandler.hasPropertyStream(poifs, "\u0005SummaryInformation");
        Assertions.assertEquals((Object)hasDSI, (Object)(dsi != null ? 1 : 0));
        Assertions.assertEquals((Object)hasSI, (Object)(si != null ? 1 : 0));
        this.handlePOIDocument(hpsf);
    }

    private static boolean hasPropertyStream(POIFSFileSystem poifs, String streamName) throws IOException {
        DirectoryNode root = poifs.getRoot();
        if (!root.hasEntry(streamName)) {
            return false;
        }
        try (DocumentInputStream dis = root.createDocumentInputStream(streamName);){
            boolean bl = PropertySet.isPropertySetStream(dis);
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleAdditional(File file) throws Exception {
        Assumptions.assumeFalse((boolean)EXCLUDES_HANDLE_ADD.contains(file.getParentFile().getName() + "/" + file.getName()));
        if (copyOutput == null) {
            copyOutput = TempFile.createTempFile("hpsfCopy", "out");
            copyOutput.deleteOnExit();
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream psNew = new PrintStream((OutputStream)bos, true, "ISO-8859-1");
        PrintStream ps = System.out;
        try {
            System.setOut(psNew);
            CopyCompare.main(new String[]{file.getAbsolutePath(), copyOutput.getAbsolutePath()});
            Assertions.assertEquals((Object)("Equal" + NL), (Object)bos.toString(StandardCharsets.UTF_8.name()));
        }
        finally {
            System.setOut(ps);
        }
    }

    @Override
    @Test
    void test() throws Exception {
        String path = "test-data/diagram/44501.vsd";
        try (FileInputStream stream = new FileInputStream(path);){
            this.handleFile(stream, path);
        }
    }

    @Test
    void testExtractor() {
        File file = new File("test-data/hpsf/TestBug44375.xls");
        Assertions.assertDoesNotThrow(() -> this.handleExtracting(file));
    }

    static {
        EXCLUDES_HANDLE_ADD = HPSFFileHandler.unmodifiableHashSet("spreadsheet/45290.xls", "spreadsheet/46904.xls", "spreadsheet/55982.xls", "spreadsheet/testEXCEL_3.xls", "spreadsheet/testEXCEL_4.xls", "hpsf/Test_Humor-Generation.ppt", "document/word2.doc");
        EXCLUDES_HANDLE_FILE = HPSFFileHandler.unmodifiableHashSet("hpsf/Test_Humor-Generation.ppt", "slideshow/missing-moveto.ppt");
    }
}

