/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.stress;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.poi.hpbf.HPBFDocument;
import org.apache.poi.hpbf.extractor.PublisherTextExtractor;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.stress.POIFSFileHandler;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HPBFFileHandler
extends POIFSFileHandler {
    HPBFFileHandler() {
    }

    @Override
    public void handleFile(InputStream stream, String path) throws Exception {
        HPBFDocument pub = new HPBFDocument(new POIFSFileSystem(stream));
        Assertions.assertNotNull((Object)pub.getEscherDelayStm());
        Assertions.assertNotNull((Object)pub.getMainContents());
        Assertions.assertNotNull((Object)pub.getQuillContents());
        pub.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Test
    void test() throws Exception {
        File file = new File("test-data/publisher/SampleBrochure.pub");
        try (FileInputStream stream = new FileInputStream(file);){
            this.handleFile(stream, file.getPath());
        }
        this.handleExtracting(file);
        stream = new FileInputStream(file);
        try (PublisherTextExtractor extractor = new PublisherTextExtractor((InputStream)stream);){
            Assertions.assertNotNull((Object)extractor.getText());
        }
        finally {
            ((InputStream)stream).close();
        }
    }
}

