/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.stress;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.apache.poi.hmef.HMEFMessage;
import org.apache.poi.hmef.attribute.MAPIAttribute;
import org.apache.poi.hmef.attribute.TNEFAttribute;
import org.apache.poi.hmef.attribute.TNEFProperty;
import org.apache.poi.hsmf.datatypes.MAPIProperty;
import org.apache.poi.poifs.filesystem.FileMagic;
import org.apache.poi.stress.AbstractFileHandler;
import org.apache.poi.util.LittleEndian;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class HMEFFileHandler
extends AbstractFileHandler {
    HMEFFileHandler() {
    }

    @Override
    public void handleExtracting(File file) throws Exception {
        FileMagic fm = FileMagic.valueOf(file);
        if (fm == FileMagic.OLE2) {
            super.handleExtracting(file);
        }
    }

    @Override
    public void handleFile(InputStream stream, String path) throws Exception {
        String bodyStr;
        HMEFMessage msg = new HMEFMessage(stream);
        String[] HTML_BODY = new String[]{"Testing TNEF Message", "TNEF test message with attachments", "Test"};
        if (Arrays.asList(HTML_BODY).contains(msg.getSubject())) {
            MAPIAttribute bodyHtml = msg.getMessageMAPIAttribute(MAPIProperty.BODY_HTML);
            Assertions.assertNotNull((Object)bodyHtml);
            bodyStr = new String(bodyHtml.getData(), this.getEncoding(msg));
        } else {
            bodyStr = msg.getBody();
        }
        Assertions.assertNotNull((Object)bodyStr, (String)"Body is not set");
        Assertions.assertNotNull((Object)msg.getSubject(), (String)"Subject is not set");
    }

    @Test
    void test() throws Exception {
        String path = "test-data/hmef/quick-winmail.dat";
        try (FileInputStream stream = new FileInputStream(path);){
            this.handleFile(stream, path);
        }
    }

    private String getEncoding(HMEFMessage tnefDat) {
        TNEFAttribute oemCP = tnefDat.getMessageAttribute(TNEFProperty.ID_OEMCODEPAGE);
        MAPIAttribute cpId = tnefDat.getMessageMAPIAttribute(MAPIProperty.INTERNET_CPID);
        int codePage = 1252;
        if (oemCP != null) {
            codePage = LittleEndian.getInt(oemCP.getData());
        } else if (cpId != null) {
            codePage = LittleEndian.getInt(cpId.getData());
        }
        switch (codePage) {
            case 1252: {
                return "Windows-1252";
            }
            case 20127: {
                return "US-ASCII";
            }
        }
        return "cp" + codePage;
    }
}

