/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.stress;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.poi.stress.FileHandler;
import org.apache.poi.stress.HDGFFileHandler;
import org.apache.poi.stress.HMEFFileHandler;
import org.apache.poi.stress.HPBFFileHandler;
import org.apache.poi.stress.HSLFFileHandler;
import org.apache.poi.stress.HSMFFileHandler;
import org.apache.poi.stress.HSSFFileHandler;
import org.apache.poi.stress.HWPFFileHandler;
import org.apache.poi.stress.OPCFileHandler;
import org.apache.poi.stress.POIFSFileHandler;
import org.apache.poi.stress.XDGFFileHandler;
import org.apache.poi.stress.XSLFFileHandler;
import org.apache.poi.stress.XSSFFileHandler;
import org.apache.poi.stress.XWPFFileHandler;

public class FileHandlerFactory {
    private static final Map<Pattern, FileHandler> MIME_TYPES = new HashMap<Pattern, FileHandler>();

    public static FileHandler getHandler(String mimeType) {
        for (Map.Entry<Pattern, FileHandler> entry : MIME_TYPES.entrySet()) {
            if (!entry.getKey().matcher(mimeType).matches()) continue;
            return entry.getValue();
        }
        return null;
    }

    static {
        MIME_TYPES.put(Pattern.compile("application/vnd.ms-word.document.macroenabled.12"), new XWPFFileHandler());
        MIME_TYPES.put(Pattern.compile("application/vnd.ms-word.template.macroenabled.12"), new XWPFFileHandler());
        MIME_TYPES.put(Pattern.compile(".*msword.*"), new HWPFFileHandler());
        MIME_TYPES.put(Pattern.compile(".*ms-word.*"), new HWPFFileHandler());
        MIME_TYPES.put(Pattern.compile(".*wordprocessingml.*"), new XWPFFileHandler());
        MIME_TYPES.put(Pattern.compile("application/vnd.ms-excel.addin.macroEnabled.12"), new XSSFFileHandler());
        MIME_TYPES.put(Pattern.compile("application/vnd.ms-excel.sheet.binary.macroEnabled.12"), new XSSFFileHandler());
        MIME_TYPES.put(Pattern.compile(".*msexcel.*"), new HSSFFileHandler());
        MIME_TYPES.put(Pattern.compile(".*ms-excel.*"), new HSSFFileHandler());
        MIME_TYPES.put(Pattern.compile(".*spreadsheetml.*"), new XSSFFileHandler());
        MIME_TYPES.put(Pattern.compile("application/vnd.ms-powerpoint"), new HSLFFileHandler());
        MIME_TYPES.put(Pattern.compile("application/vnd.ms-officetheme"), new HSLFFileHandler());
        MIME_TYPES.put(Pattern.compile(".*presentationml.*"), new XSLFFileHandler());
        MIME_TYPES.put(Pattern.compile("application/vnd.ms-powerpoint.presentation.macroenabled.12"), new XSLFFileHandler());
        MIME_TYPES.put(Pattern.compile("application/vnd.ms-powerpoint.slideshow.macroenabled.12"), new XSLFFileHandler());
        MIME_TYPES.put(Pattern.compile(".*ms-tnef.*"), new HMEFFileHandler());
        MIME_TYPES.put(Pattern.compile("application/vnd.ms-outlook"), new HSMFFileHandler());
        MIME_TYPES.put(Pattern.compile("application/vnd.visio.*"), new HDGFFileHandler());
        MIME_TYPES.put(Pattern.compile(".*vnd.ms-visio\\."), new XDGFFileHandler());
        MIME_TYPES.put(Pattern.compile(".*visio.*"), new HDGFFileHandler());
        MIME_TYPES.put(Pattern.compile("application/x-mspublisher"), new HPBFFileHandler());
        MIME_TYPES.put(Pattern.compile("application/x-tika-ooxml.*"), new OPCFileHandler());
        MIME_TYPES.put(Pattern.compile("application/x-tika-msoffice.*"), new POIFSFileHandler());
        MIME_TYPES.put(Pattern.compile("application/x-tika-old-excel"), new POIFSFileHandler());
    }
}

