/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.stress;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.extractor.ExtractorFactory;
import org.apache.poi.extractor.POIOLE2TextExtractor;
import org.apache.poi.extractor.POITextExtractor;
import org.apache.poi.hpsf.extractor.HPSFPropertiesExtractor;
import org.apache.poi.hssf.extractor.EventBasedExcelExtractor;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.ss.extractor.ExcelExtractor;
import org.apache.poi.stress.FileHandler;
import org.apache.poi.util.IOUtils;
import org.apache.xmlbeans.XmlException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;

public abstract class AbstractFileHandler
implements FileHandler {
    public static final Set<String> EXPECTED_EXTRACTOR_FAILURES = new HashSet<String>();

    @Override
    public void handleExtracting(File file) throws Exception {
        boolean before = ExtractorFactory.getThreadPrefersEventExtractors();
        try {
            ExtractorFactory.setThreadPrefersEventExtractors(true);
            this.handleExtractingInternal(file);
            ExtractorFactory.setThreadPrefersEventExtractors(false);
            this.handleExtractingInternal(file);
        }
        finally {
            ExtractorFactory.setThreadPrefersEventExtractors(before);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExtractingInternal(File file) throws Exception {
        long length = file.length();
        long modified = file.lastModified();
        POITextExtractor extractor = null;
        String fileAndParentName = file.getParentFile().getName() + "/" + file.getName();
        try {
            extractor = ExtractorFactory.createExtractor(file);
            Assertions.assertNotNull((Object)extractor, (String)("Should get a POITextExtractor but had none for file " + file));
            Assertions.assertNotNull((Object)extractor.getText(), (String)("Should get some text but had none for file " + file));
            POITextExtractor metadataExtractor = extractor.getMetadataTextExtractor();
            Assertions.assertNotNull((Object)metadataExtractor.getText());
            Assertions.assertFalse((boolean)EXPECTED_EXTRACTOR_FAILURES.contains(fileAndParentName), (String)("Expected Extraction to fail for file " + file + " and handler " + this + ", but did not fail!"));
            Assertions.assertEquals((long)length, (long)file.length(), (String)"File should not be modified by extractor");
            Assertions.assertEquals((long)modified, (long)file.lastModified(), (String)"File should not be modified by extractor");
            this.handleExtractingAsStream(file);
            if (extractor instanceof POIOLE2TextExtractor) {
                try (HPSFPropertiesExtractor hpsfExtractor = new HPSFPropertiesExtractor((POIOLE2TextExtractor)extractor);){
                    Assertions.assertNotNull((Object)hpsfExtractor.getDocumentSummaryInformationText());
                    Assertions.assertNotNull((Object)hpsfExtractor.getSummaryInformationText());
                    String text = hpsfExtractor.getText();
                    Assertions.assertNotNull((Object)text);
                }
            }
            if (extractor instanceof ExcelExtractor && !(extractor instanceof EventBasedExcelExtractor)) {
                ((ExcelExtractor)((Object)extractor)).setFormulasNotResults(true);
                String text = extractor.getText();
                Assertions.assertNotNull((Object)text);
                ((ExcelExtractor)((Object)extractor)).setIncludeCellComments(true);
                text = extractor.getText();
                Assertions.assertNotNull((Object)text);
            }
        }
        catch (IllegalArgumentException e) {
            if (!EXPECTED_EXTRACTOR_FAILURES.contains(fileAndParentName)) {
                throw e;
            }
        }
        catch (EncryptedDocumentException e) {
            String msg = "org.apache.poi.EncryptedDocumentException: Export Restrictions in place - please install JCE Unlimited Strength Jurisdiction Policy files";
            Assumptions.assumeFalse((boolean)msg.equals(e.getMessage()));
            throw e;
        }
        catch (IllegalStateException e) {
            if (!e.getMessage().contains("POI Scratchpad jar missing") || !Boolean.getBoolean("scratchpad.ignore")) {
                throw e;
            }
        }
        finally {
            IOUtils.closeQuietly(extractor);
        }
    }

    private void handleExtractingAsStream(File file) throws IOException, OpenXML4JException, XmlException {
        try (FileInputStream stream = new FileInputStream(file);
             POITextExtractor streamExtractor = ExtractorFactory.createExtractor(stream);){
            Assertions.assertNotNull((Object)streamExtractor);
            Assertions.assertNotNull((Object)streamExtractor.getText());
        }
    }

    @Override
    public void handleAdditional(File file) throws Exception {
    }

    static {
        EXPECTED_EXTRACTOR_FAILURES.add("hmef/quick-winmail.dat");
        EXPECTED_EXTRACTOR_FAILURES.add("hmef/winmail-sample1.dat");
        EXPECTED_EXTRACTOR_FAILURES.add("hmef/bug52400-winmail-simple.dat");
        EXPECTED_EXTRACTOR_FAILURES.add("hmef/bug52400-winmail-with-attachments.dat");
        EXPECTED_EXTRACTOR_FAILURES.add("hmef/bug63955-winmail.dat");
        EXPECTED_EXTRACTOR_FAILURES.add("hpsf/Test0313rur.adm");
        EXPECTED_EXTRACTOR_FAILURES.add("poifs/Notes.ole2");
        EXPECTED_EXTRACTOR_FAILURES.add("poifs/64322.ole2");
    }
}

