/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.xwpf.usermodel;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.util.Units;
import org.apache.poi.xwpf.usermodel.BreakType;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public final class SimpleImages {
    private SimpleImages() {
    }

    public static void main(String[] args) throws IOException, InvalidFormatException {
        try (XWPFDocument doc = new XWPFDocument();){
            XWPFParagraph p = doc.createParagraph();
            XWPFRun r = p.createRun();
            for (String imgFile : args) {
                int format;
                if (imgFile.endsWith(".emf")) {
                    format = 2;
                } else if (imgFile.endsWith(".wmf")) {
                    format = 3;
                } else if (imgFile.endsWith(".pict")) {
                    format = 4;
                } else if (imgFile.endsWith(".jpeg") || imgFile.endsWith(".jpg")) {
                    format = 5;
                } else if (imgFile.endsWith(".png")) {
                    format = 6;
                } else if (imgFile.endsWith(".dib")) {
                    format = 7;
                } else if (imgFile.endsWith(".gif")) {
                    format = 8;
                } else if (imgFile.endsWith(".tiff")) {
                    format = 9;
                } else if (imgFile.endsWith(".eps")) {
                    format = 10;
                } else if (imgFile.endsWith(".bmp")) {
                    format = 11;
                } else if (imgFile.endsWith(".wpg")) {
                    format = 12;
                } else {
                    System.err.println("Unsupported picture: " + imgFile + ". Expected emf|wmf|pict|jpeg|png|dib|gif|tiff|eps|bmp|wpg");
                    continue;
                }
                r.setText(imgFile);
                r.addBreak();
                try (FileInputStream is = new FileInputStream(imgFile);){
                    r.addPicture(is, format, imgFile, Units.toEMU(200.0), Units.toEMU(200.0));
                }
                r.addBreak(BreakType.PAGE);
            }
            try (FileOutputStream out = new FileOutputStream("images.docx");){
                doc.write(out);
            }
        }
    }
}

