/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.xssf.usermodel;

import java.io.FileOutputStream;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.xddf.usermodel.PresetColor;
import org.apache.poi.xddf.usermodel.XDDFColor;
import org.apache.poi.xddf.usermodel.XDDFFillProperties;
import org.apache.poi.xddf.usermodel.XDDFLineProperties;
import org.apache.poi.xddf.usermodel.XDDFShapeProperties;
import org.apache.poi.xddf.usermodel.XDDFSolidFillProperties;
import org.apache.poi.xddf.usermodel.chart.AxisPosition;
import org.apache.poi.xddf.usermodel.chart.AxisTickLabelPosition;
import org.apache.poi.xddf.usermodel.chart.BarDirection;
import org.apache.poi.xddf.usermodel.chart.ChartTypes;
import org.apache.poi.xddf.usermodel.chart.LegendPosition;
import org.apache.poi.xddf.usermodel.chart.XDDFBarChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryAxis;
import org.apache.poi.xddf.usermodel.chart.XDDFCategoryDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFChartLegend;
import org.apache.poi.xddf.usermodel.chart.XDDFDataSourcesFactory;
import org.apache.poi.xddf.usermodel.chart.XDDFLegendEntry;
import org.apache.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import org.apache.poi.xddf.usermodel.chart.XDDFScatterChartData;
import org.apache.poi.xddf.usermodel.chart.XDDFValueAxis;
import org.apache.poi.xddf.usermodel.text.XDDFRunProperties;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFChart;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class ExcelChartWithTargetLine {
    private static final int NUM_OF_ROWS = 6;

    private ExcelChartWithTargetLine() {
    }

    private static void createChart(XSSFChart chart, XSSFSheet sheet, int[] chartedCols, double target) {
        XDDFFillProperties[] fills = new XDDFFillProperties[]{new XDDFSolidFillProperties(XDDFColor.from(PresetColor.TURQUOISE)), new XDDFSolidFillProperties(XDDFColor.from(PresetColor.CHARTREUSE)), new XDDFSolidFillProperties(XDDFColor.from(PresetColor.LAVENDER)), new XDDFSolidFillProperties(XDDFColor.from(PresetColor.CHOCOLATE)), new XDDFSolidFillProperties(XDDFColor.from(PresetColor.TOMATO)), new XDDFSolidFillProperties(XDDFColor.from(PresetColor.PLUM))};
        XDDFLineProperties solidTurquoise = new XDDFLineProperties(fills[0]);
        XDDFLineProperties solidTomato = new XDDFLineProperties(fills[4]);
        XDDFLineProperties solidPlum = new XDDFLineProperties(fills[5]);
        XDDFSolidFillProperties solidAlmond = new XDDFSolidFillProperties(XDDFColor.from(PresetColor.BLANCHED_ALMOND));
        XDDFSolidFillProperties solidGray = new XDDFSolidFillProperties(XDDFColor.from(PresetColor.DARK_SLATE_GRAY));
        XDDFCategoryAxis barCategories = chart.createCategoryAxis(AxisPosition.BOTTOM);
        XDDFValueAxis leftValues = chart.createValueAxis(AxisPosition.LEFT);
        leftValues.crossAxis(barCategories);
        barCategories.crossAxis(leftValues);
        leftValues.getOrAddMajorGridProperties().setLineProperties(solidTomato);
        leftValues.getOrAddShapeProperties().setLineProperties(solidPlum);
        XDDFRunProperties props = leftValues.getOrAddTextProperties();
        props.setFontSize(14.0);
        props.setFillProperties(fills[5]);
        XDDFBarChartData bar = (XDDFBarChartData)chart.createData(ChartTypes.BAR, barCategories, leftValues);
        bar.setVaryColors(true);
        bar.setBarDirection(chartedCols.length > 1 ? BarDirection.COL : BarDirection.BAR);
        for (int c : chartedCols) {
            XDDFCategoryDataSource xs = XDDFDataSourcesFactory.fromStringCellRange(sheet, new CellRangeAddress(1, 6, 0, 0));
            XDDFNumericalDataSource<Double> ys = XDDFDataSourcesFactory.fromNumericCellRange(sheet, new CellRangeAddress(1, 6, c, c));
            XDDFBarChartData.Series series = (XDDFBarChartData.Series)bar.addSeries(xs, ys);
            series.setTitle(null, new CellReference(sheet.getSheetName(), 0, c, true, true));
            series.setFillProperties(fills[c]);
            series.setLineProperties(solidTurquoise);
        }
        chart.plot(bar);
        XDDFValueAxis scatterX = chart.createValueAxis(AxisPosition.TOP);
        scatterX.setVisible(false);
        scatterX.setTickLabelPosition(AxisTickLabelPosition.NONE);
        XDDFValueAxis scatterY = chart.createValueAxis(AxisPosition.RIGHT);
        scatterY.setVisible(false);
        scatterY.setTickLabelPosition(AxisTickLabelPosition.NONE);
        scatterX.crossAxis(scatterY);
        scatterY.crossAxis(scatterX);
        if (chartedCols.length > 1) {
            scatterX.setMaximum(1.0);
        } else {
            scatterY.setMaximum(1.0);
        }
        XDDFScatterChartData scatter = (XDDFScatterChartData)chart.createData(ChartTypes.SCATTER, scatterX, scatterY);
        scatter.setVaryColors(true);
        XDDFNumericalDataSource targetDS = XDDFDataSourcesFactory.fromArray((Number[])new Double[]{target, target});
        XDDFNumericalDataSource zeroOneDS = XDDFDataSourcesFactory.fromArray((Number[])new Double[]{0.0, 1.0});
        if (chartedCols.length > 1) {
            scatter.addSeries(zeroOneDS, targetDS).setLineProperties(solidTurquoise);
        } else {
            scatter.addSeries(targetDS, zeroOneDS).setLineProperties(solidTurquoise);
        }
        chart.plot(scatter);
        if (chartedCols.length > 1) {
            XDDFChartLegend legend = chart.getOrAddLegend();
            legend.setPosition(LegendPosition.LEFT);
            legend.setOverlay(false);
            XDDFLegendEntry entry = legend.addEntry();
            entry.setIndex(0L);
            entry.setDelete(true);
        }
        chart.setAutoTitleDeleted(false);
        XDDFShapeProperties chartProps = chart.getOrAddShapeProperties();
        chartProps.setFillProperties(solidAlmond);
        chartProps.setLineProperties(new XDDFLineProperties(solidGray));
        XDDFLineProperties categoriesProps = new XDDFLineProperties(solidGray);
        categoriesProps.setWidth(2.1);
        barCategories.getOrAddShapeProperties().setLineProperties(categoriesProps);
    }

    private static XSSFClientAnchor createAnchor(XSSFDrawing drawing, int[] chartedCols) {
        if (chartedCols.length > 1) {
            return drawing.createAnchor(0, 0, 0, 0, 0, 8, 10, 23);
        }
        return drawing.createAnchor(0, 0, 0, 0, 0, 8, 5, 23);
    }

    public static void main(String[] args) throws Exception {
        try (XSSFWorkbook workbook = new XSSFWorkbook();){
            XSSFCell cell;
            XSSFSheet sheet = workbook.createSheet("targetline");
            int NUM_OF_COLUMNS = 4;
            String[] headings = new String[]{"Year", "Male", "Female", "Other"};
            int rowIndex = 0;
            XSSFRow row = sheet.createRow(rowIndex);
            for (int colIndex = 0; colIndex < 4; ++colIndex) {
                cell = row.createCell(colIndex);
                cell.setCellValue(headings[colIndex]);
            }
            double[][] values = new double[][]{{1980.0, 56.0, 44.1, 12.2}, {1985.0, 34.5, 41.0, 4.0}, {1990.0, 65.0, 68.5, 9.1}, {1995.0, 34.7, 47.6, 4.9}, {2000.0, 23.0, 64.5, 11.1}, {2005.0, 56.3, 69.8, 9.5}};
            while (rowIndex < 6) {
                row = sheet.createRow(rowIndex + 1);
                for (int colIndex = 0; colIndex < 4; ++colIndex) {
                    cell = row.createCell(colIndex);
                    cell.setCellValue(values[rowIndex][colIndex]);
                }
                ++rowIndex;
            }
            int[] chartedCols = new int[]{1, 2, 3};
            XSSFDrawing drawing = sheet.createDrawingPatriarch();
            XSSFClientAnchor anchor = ExcelChartWithTargetLine.createAnchor(drawing, chartedCols);
            XSSFChart chart = drawing.createChart(anchor);
            ExcelChartWithTargetLine.createChart(chart, sheet, chartedCols, 42.0);
            try (FileOutputStream fos = new FileOutputStream("ExcelChartWithTargetLine.xlsx");){
                workbook.write(fos);
            }
        }
    }
}

