/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.xssf.eventusermodel;

import java.io.InputStream;
import org.apache.poi.examples.xssf.usermodel.LoadPasswordProtectedXlsx;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.poifs.crypt.temp.AesZipFileZipEntrySource;
import org.apache.poi.xssf.eventusermodel.XSSFReader;

public final class LoadPasswordProtectedXlsxStreaming {
    private LoadPasswordProtectedXlsxStreaming() {
    }

    public static void main(String[] args) throws Exception {
        LoadPasswordProtectedXlsx.execute(args, LoadPasswordProtectedXlsxStreaming::printSheetCount);
    }

    private static void printSheetCount(InputStream inputStream) throws Exception {
        try (AesZipFileZipEntrySource source = AesZipFileZipEntrySource.createZipEntrySource(inputStream);
             OPCPackage pkg = OPCPackage.open(source);){
            XSSFReader reader = new XSSFReader(pkg);
            XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)reader.getSheetsData();
            int count = 0;
            while (iter.hasNext()) {
                iter.next();
                ++count;
            }
            System.out.println("sheet count: " + count);
        }
    }
}

