/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.ss;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hssf.usermodel.HSSFObjectData;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.ooxml.POIXMLDocument;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.xmlbeans.XmlException;

public final class LoadEmbedded {
    private LoadEmbedded() {
    }

    public static void main(String[] args) throws IOException, EncryptedDocumentException, OpenXML4JException, XmlException {
        Workbook wb = WorkbookFactory.create(new File(args[0]));
        LoadEmbedded.loadEmbedded(wb);
    }

    public static void loadEmbedded(Workbook wb) throws IOException, InvalidFormatException, OpenXML4JException, XmlException {
        if (wb instanceof HSSFWorkbook) {
            LoadEmbedded.loadEmbedded((HSSFWorkbook)wb);
        } else if (wb instanceof XSSFWorkbook) {
            LoadEmbedded.loadEmbedded((XSSFWorkbook)wb);
        } else {
            throw new IllegalArgumentException(wb.getClass().getName());
        }
    }

    public static void loadEmbedded(HSSFWorkbook workbook) throws IOException {
        for (HSSFObjectData obj : workbook.getAllEmbeddedObjects()) {
            DirectoryNode dn;
            String oleName = obj.getOLE2ClassName();
            if (oleName.equals("Worksheet")) {
                dn = (DirectoryNode)obj.getDirectory();
                HSSFWorkbook embeddedWorkbook = new HSSFWorkbook(dn, false);
                embeddedWorkbook.close();
                continue;
            }
            if (oleName.equals("Document")) {
                dn = (DirectoryNode)obj.getDirectory();
                HWPFDocument embeddedWordDocument = new HWPFDocument(dn);
                embeddedWordDocument.close();
                continue;
            }
            if (oleName.equals("Presentation")) {
                dn = (DirectoryNode)obj.getDirectory();
                HSLFSlideShow embeddedSlieShow = new HSLFSlideShow(dn);
                embeddedSlieShow.close();
                continue;
            }
            if (obj.hasDirectoryEntry()) {
                dn = (DirectoryNode)obj.getDirectory();
                for (Entry entry : dn) {
                }
                continue;
            }
            byte[] byArray = obj.getObjectData();
        }
    }

    public static void loadEmbedded(XSSFWorkbook workbook) throws IOException, InvalidFormatException, OpenXML4JException, XmlException {
        for (PackagePart pPart : workbook.getAllEmbeddedParts()) {
            Object slideShow;
            Object document;
            Workbook embeddedWorkbook;
            String contentType = pPart.getContentType();
            if (contentType.equals("application/vnd.ms-excel")) {
                embeddedWorkbook = new HSSFWorkbook(pPart.getInputStream());
                ((HSSFWorkbook)embeddedWorkbook).close();
                continue;
            }
            if (contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")) {
                embeddedWorkbook = new XSSFWorkbook(pPart.getInputStream());
                ((XSSFWorkbook)embeddedWorkbook).close();
                continue;
            }
            if (contentType.equals("application/msword")) {
                document = new HWPFDocument(pPart.getInputStream());
                document.close();
                continue;
            }
            if (contentType.equals("application/vnd.openxmlformats-officedocument.wordprocessingml.document")) {
                document = new XWPFDocument(pPart.getInputStream());
                ((POIXMLDocument)document).close();
                continue;
            }
            if (contentType.equals("application/vnd.ms-powerpoint")) {
                slideShow = new HSLFSlideShow(pPart.getInputStream());
                slideShow.close();
                continue;
            }
            if (contentType.equals("application/vnd.openxmlformats-officedocument.presentationml.presentation")) {
                slideShow = new XMLSlideShow(pPart.getInputStream());
                ((POIXMLDocument)slideShow).close();
                continue;
            }
            System.out.println("Unknown Embedded Document: " + contentType);
            InputStream inputStream = pPart.getInputStream();
            inputStream.close();
        }
    }
}

