/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.examples.hssf.usermodel;

import java.io.FileInputStream;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hssf.usermodel.HSSFObjectData;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;

public final class EmbeddedObjects {
    private EmbeddedObjects() {
    }

    public static void main(String[] args) throws Exception {
        try (FileInputStream fis = new FileInputStream(args[0]);
             POIFSFileSystem fs = new POIFSFileSystem(fis);
             HSSFWorkbook workbook = new HSSFWorkbook(fs);){
            for (HSSFObjectData obj : workbook.getAllEmbeddedObjects()) {
                String oleName = obj.getOLE2ClassName();
                DirectoryNode dn = obj.hasDirectoryEntry() ? (DirectoryNode)obj.getDirectory() : null;
                Object document = null;
                switch (oleName) {
                    case "Worksheet": {
                        document = new HSSFWorkbook(dn, fs, false);
                        break;
                    }
                    case "Document": {
                        document = new HWPFDocument(dn);
                        break;
                    }
                    case "Presentation": {
                        document = new HSLFSlideShow(dn);
                        break;
                    }
                    default: {
                        if (dn != null) {
                            for (Entry entry : dn) {
                                String string = entry.getName();
                            }
                            break;
                        }
                        Object object = obj.getObjectData();
                    }
                }
                if (document == null) continue;
                document.close();
            }
        }
    }
}

