/*
 * Decompiled with CFR 0.152.
 */
package de.sanchofock.dsa.tool;

import de.sanchofock.dsa.character.CharacterGroup;
import de.sanchofock.dsa.character.DSA1Held;
import de.sanchofock.dsa.character.DSACharacter;

public abstract class GameLog {
    protected abstract void logEvent(String var1);

    public void logFight(CharacterGroup _sideA, CharacterGroup _sideB) {
        this.logEvent("---Neuer Kampf---");
        this.logEvent("es treten an:");
        int i = 0;
        while (i < _sideA.getSize()) {
            this.logEvent(_sideA.getCharacter(i).getSummary());
            ++i;
        }
        this.logEvent("gegen:");
        i = 0;
        while (i < _sideB.getSize()) {
            this.logEvent(_sideB.getCharacter(i).getSummary());
            ++i;
        }
        this.logEvent("Es geht los:");
    }

    public void logCharStat(DSACharacter _char) {
        this.logEvent(_char.getSummary());
    }

    public void logNewFightRound(int _roundNo) {
        this.logEvent("");
        this.logEvent("----Kampfrunde " + Integer.toString(_roundNo) + " beginnt:");
    }

    public void logAngriff(DSACharacter _angreifer, DSACharacter _verteidiger, boolean _atOK, boolean _paOK, int _tp) {
        String logEntry = String.valueOf(_angreifer.getName()) + " greift " + _verteidiger.getName() + " an :";
        if (!_atOK) {
            logEntry = String.valueOf(logEntry) + "AT misslingt";
        } else {
            logEntry = String.valueOf(logEntry) + "AT gelingt";
            if (_paOK) {
                logEntry = String.valueOf(logEntry) + " --- PA gelingt";
            } else {
                logEntry = String.valueOf(logEntry) + " --- PA misslingt TREFFER:" + Integer.toString(_tp) + " - Rest LE: " + Integer.toString(_verteidiger.getLebensenergie());
                if (!_verteidiger.isAlive()) {
                    logEntry = String.valueOf(logEntry) + " -> " + _verteidiger.getName() + " ist gestorben ";
                }
            }
        }
        this.logEvent(logEntry);
    }

    public void logSurvivor(CharacterGroup _surviors) {
        String logEntry = "Der kampf ist beendet \u00dcberlebende: " + _surviors.getCharacter(0).getName();
        this.logEvent("");
        int i = 1;
        while (i < _surviors.getSize()) {
            logEntry = String.valueOf(logEntry) + ", " + _surviors.getCharacter(i).getSummary();
            ++i;
        }
        this.logEvent(logEntry);
    }

    public void logProbe(String _eigenschaft, boolean _gelungen) {
        this.logEvent("");
        String gel = "GELUNGEN";
        if (!_gelungen) {
            gel = "NICHT GELUNGEN";
        }
        this.logEvent(String.format("Die Probe auf %s ist %s", _eigenschaft, gel));
    }

    public void logNeueWaffe(DSACharacter _char) {
        this.logEvent("");
        this.logEvent(String.format("%s tr\u00e4gt jetzt eine neue Waffe und hat nun %s Trefferpunkte", _char.getName(), _char.getTreffer()));
        this.logEvent("Neuer Status:");
        this.logEvent(_char.getSummary());
    }

    public void logAddRS(DSACharacter _char, int _rs) {
        this.logEvent("");
        this.logEvent(String.format("%s hat zus\u00e4tzliche R\u00fcstung (%d) erhalten", _char.getName(), _rs));
        this.logEvent("Neuer Status:");
        this.logEvent(_char.getSummary());
    }

    public void logHeiltrank(DSACharacter _char, int _le) {
        this.logEvent("");
        this.logEvent(String.format("%s trinkt einen Heiltran (%d LP)", _char.getName(), _le));
        this.logEvent("Neuer Status:");
        this.logEvent(_char.getSummary());
    }

    public void logAbenteuerpunkte(DSACharacter _char, int _ap) {
        this.logEvent("");
        this.logEvent(String.format("%s erh\u00e4lt %d AP", _char.getName(), _ap));
        this.logEvent("Neuer Status:");
        this.logEvent(_char.getSummary());
    }

    public void logReceiveSilbertaler(DSACharacter _char, int _st) {
        this.logEvent("");
        this.logEvent(String.format("%s erh\u00e4lt %d Silbertaler", _char.getName(), _st));
        this.logEvent("Neuer Status:");
        this.logEvent(_char.getSummary());
    }

    public void logLooseSilbertaler(DSACharacter _char, int _st) {
        this.logEvent("");
        this.logEvent(String.format("%s verliert %d Silbertaler", _char.getName(), _st));
        this.logEvent("Neuer Status:");
        this.logEvent(_char.getSummary());
    }

    public void logSP(DSACharacter _char, int _sp) {
        this.logEvent("");
        this.logEvent(String.format("%s musste einen Schaden von %d SP hinnehmen", _char.getName(), _sp));
        this.logEvent("Neuer Status:");
        this.logEvent(_char.getSummary());
    }

    public void logTP(DSACharacter _char, int _tp) {
        int schaden = _char.getRuestung() - _tp;
        this.logEvent("");
        if (schaden >= 0) {
            this.logEvent(String.format("%s musste %d TP einstecken. Der Schaden betr\u00e4gt %d SP", _char.getName(), _tp, schaden));
            this.logEvent("Neuer Status:");
            this.logEvent(_char.getSummary());
        } else {
            this.logEvent(String.format("%s musste einen Treffer einstecken. Der Treffer bleibt in der R\u00fcstung stecken", _char.getName()));
        }
    }

    public void logInventory(DSACharacter _char, String _newItem) {
        this.logEvent("");
        if (_newItem != null) {
            this.logEvent(String.format("%s hat einen Gegenstand (%s) mitgenommen", _char.getName(), _newItem));
        }
        this.logEvent("Inventarliste:");
        DSA1Held hero = (DSA1Held)_char;
        this.logEvent(hero.getInventory());
    }

    public void logCheckForItem(Boolean _found) {
        this.logEvent("");
        if (_found.booleanValue()) {
            this.logEvent("Der ben\u00f6tigte Gegenstand befindet sich im Inventar");
        } else {
            this.logEvent("Der ben\u00f6tigte Gegenstand befindet sich NICHT im Inventar");
        }
        this.logEvent("");
    }

    public void logMessage(String _msg) {
        this.logEvent(_msg);
    }
}

