/*
 * Decompiled with CFR 0.152.
 */
package de.sanchofock.dsa.convert;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Iterator;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

public class ConvertXLS {
    /*
     * Enabled aggressive block sorting
     */
    private static void writeSheet(FileWriter _writer, HSSFSheet _mySheet, int _firstCol, int _lastCol) throws IOException {
        Iterator<Row> rowIterator = _mySheet.iterator();
        String line = "";
        rowIterator.next();
        while (rowIterator.hasNext()) {
            Row row = rowIterator.next();
            line = "";
            Iterator<Cell> cellIterator = row.cellIterator();
            int curCol = 0;
            block10: while (cellIterator.hasNext()) {
                Cell cell = cellIterator.next();
                if (!(++curCol >= _firstCol & curCol <= _lastCol)) continue;
                switch (cell.getCellType()) {
                    case STRING: {
                        if (!(!"".equals(cell.getRichStringCellValue().getString()) & cell.getRichStringCellValue().getString() != null)) continue block10;
                        line = String.valueOf(line) + cell.getRichStringCellValue().getString() + "\t";
                        break;
                    }
                    case NUMERIC: {
                        line = String.format("%s%.0f\t", line, cell.getNumericCellValue());
                        break;
                    }
                    case FORMULA: {
                        switch (cell.getCachedFormulaResultType()) {
                            case STRING: {
                                if (!(!"".equals(cell.getRichStringCellValue().getString()) & cell.getRichStringCellValue().getString() != null)) break;
                                line = String.valueOf(line) + cell.getRichStringCellValue().getString() + "\t";
                                break;
                            }
                            case NUMERIC: {
                                line = String.format("%s%.0f\t", line, cell.getNumericCellValue());
                            }
                        }
                        break;
                    }
                }
            }
            if ("".equals(line)) continue;
            _writer.write(String.valueOf(line) + "\r\n");
        }
    }

    public static void convertAdventure(String _inFile, String _outFile) {
        try {
            File myFile = new File(_inFile);
            FileWriter writer = new FileWriter(_outFile, false);
            FileInputStream fis = new FileInputStream(myFile);
            HSSFWorkbook myWorkBook = new HSSFWorkbook(fis);
            HSSFSheet mySheet = myWorkBook.getSheet("Text");
            ConvertXLS.writeSheet(writer, mySheet, 1, 100);
            mySheet = myWorkBook.getSheet("Actions");
            ConvertXLS.writeSheet(writer, mySheet, 2, 6);
            mySheet = myWorkBook.getSheet("Proben");
            ConvertXLS.writeSheet(writer, mySheet, 2, 6);
            mySheet = myWorkBook.getSheet("Fight");
            ConvertXLS.writeSheet(writer, mySheet, 2, 100);
            mySheet = myWorkBook.getSheet("PickUp");
            ConvertXLS.writeSheet(writer, mySheet, 2, 6);
            mySheet = myWorkBook.getSheet("Checks");
            ConvertXLS.writeSheet(writer, mySheet, 2, 6);
            mySheet = myWorkBook.getSheet("Promt");
            ConvertXLS.writeSheet(writer, mySheet, 2, 100);
            writer.close();
            myWorkBook.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

