/*
 * Decompiled with CFR 0.152.
 */
package de.sanchofock.dsa.character;

import de.sanchofock.dsa.tool.Wuerfel;
import de.sanchofock.dsa.types.ATResult;
import de.sanchofock.dsa.types.FightTypes;

public class DSACharacter {
    private String FName = "Unknown Character";
    private int MU = -1;
    private int AT = -1;
    private int PA = -1;
    private int LE = -1;
    private int LEmax = -1;
    private int RS = -1;
    private int TPtyp = 0;
    private int TPfixum = -1;
    private Wuerfel myDice = null;
    private boolean FcanPA = true;

    protected void initBaseChar(String _cName, int _mu, int _at, int _pa, int _le, int _rs, int _tp_type, int _tp_fix) {
        this.myDice = new Wuerfel();
        this.FName = _cName;
        this.MU = _mu;
        this.AT = _at;
        this.PA = _pa;
        this.LE = _le;
        this.LEmax = _le;
        this.RS = _rs;
        this.TPtyp = _tp_type;
        this.TPfixum = _tp_fix;
    }

    protected Wuerfel dice() {
        if (this.myDice == null) {
            this.myDice = new Wuerfel();
        }
        return this.myDice;
    }

    protected void setTreffer(int _newType, int _newBonus) {
        this.TPtyp = _newType;
        this.TPfixum = _newBonus;
    }

    protected String getTTypName() {
        return FightTypes.getTypeName(this.TPtyp);
    }

    protected int getTFix() {
        return this.TPfixum;
    }

    public void reAnimate() {
        this.LE = this.LEmax;
    }

    public DSACharacter() {
    }

    public DSACharacter(String _cName, int _mu, int _at, int _pa, int _le, int _rs, int _tp_type, int _tp_fix) {
        this.initBaseChar(_cName, _mu, _at, _pa, _le, _rs, _tp_type, _tp_fix);
    }

    public ATResult doAttake() {
        int atWert = this.myDice.getW20Wurf();
        return new ATResult(atWert <= this.AT, false);
    }

    public boolean doParade() {
        if (this.FcanPA) {
            this.FcanPA = false;
            return this.myDice.getW20Wurf() <= this.PA;
        }
        return false;
    }

    public void newKampfrunde() {
        this.FcanPA = true;
    }

    public int getTrefferpunkte() {
        switch (this.TPtyp) {
            case 1: {
                return this.myDice.getW6Wurf() + this.TPfixum;
            }
            case 2: {
                return this.myDice.getW6Wurf() + this.myDice.getW6Wurf() + this.TPfixum;
            }
            case 3: {
                return this.myDice.getW6Wurf() + this.myDice.getW6Wurf() + this.myDice.getW6Wurf() + this.TPfixum;
            }
            case 4: {
                return this.myDice.getW20Wurf() + this.TPfixum;
            }
            case 5: {
                return this.TPfixum;
            }
            case 6: {
                return this.TPfixum;
            }
        }
        return 0;
    }

    public int trinkHeiltrank(int _lp) {
        this.LE = this.LE + _lp > this.LEmax ? this.LEmax : (this.LE += _lp);
        return this.LE;
    }

    public int trefferKassieren(boolean _isCritical, int _tp) {
        if (_isCritical) {
            this.LE -= _tp;
        } else if (_tp > this.RS) {
            this.LE -= _tp - this.RS;
        }
        return this.LE;
    }

    public boolean isAlive() {
        return this.LE > 0;
    }

    public int getMU() {
        return this.MU;
    }

    public int getAttake() {
        return this.AT;
    }

    public int getParade() {
        return this.PA;
    }

    public int getLebensenergie() {
        return this.LE;
    }

    public int getRuestung() {
        return this.RS;
    }

    public int addRuestung(int _rs) {
        this.RS += _rs;
        return this.getRuestung();
    }

    public int removeRuestung(int _rs) {
        this.RS -= _rs;
        if (this.RS < 0) {
            this.RS = 0;
        }
        return this.getRuestung();
    }

    public String getTreffer() {
        String myfix = " + ";
        myfix = this.TPfixum == 0 ? "" : (this.TPfixum < 0 ? " " + Integer.toString(this.TPfixum) : String.valueOf(myfix) + Integer.toString(this.TPfixum));
        return String.valueOf(FightTypes.getTypeName(this.TPtyp)) + myfix;
    }

    public String getName() {
        return this.FName;
    }

    public String getSummary() {
        return String.format("%s  LE(%d), MU(%d), AT(%d), PA(%d), Trefferpunkte(%s), RS(%d)", this.getName(), this.getLebensenergie(), this.getMU(), this.getAttake(), this.getParade(), this.getTreffer(), this.getRuestung());
    }
}

