/*
 * Decompiled with CFR 0.152.
 */
package de.sanchofock.dsa.character;

import de.sanchofock.dsa.character.DSACharacter;
import de.sanchofock.dsa.types.ATResult;
import de.sanchofock.dsa.types.FightTypes;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Scanner;

public class DSA1Held
extends DSACharacter {
    private int KL = -1;
    private int CH = -1;
    private int GE = -1;
    private int KK = -1;
    private int AP = 0;
    private int FVermoegen = -1;
    private String FTyp = null;
    private HashMap<String, String> FCollectedItems = new HashMap();
    private HashMap<String, String> FCollectedEvents = new HashMap();

    protected void initHero(HashMap<String, String> _vals) {
        String name = _vals.get("NAME");
        int trTyp = FightTypes.getType(_vals.get("TREFFER"));
        int mu = Integer.parseInt(_vals.get("MU"));
        int at = Integer.parseInt(_vals.get("AT"));
        int pa = Integer.parseInt(_vals.get("PA"));
        int tbon = Integer.parseInt(_vals.get("TBONUS"));
        int rs = Integer.parseInt(_vals.get("RS"));
        int le = Integer.parseInt(_vals.get("LE"));
        this.initBaseChar(name, mu, at, pa, le, rs, trTyp, tbon);
        this.FTyp = _vals.get("TYPUS");
        this.KL = Integer.parseInt(_vals.get("KL"));
        this.CH = Integer.parseInt(_vals.get("CH"));
        this.GE = Integer.parseInt(_vals.get("GE"));
        this.KK = Integer.parseInt(_vals.get("KK"));
        this.AP = Integer.parseInt(_vals.get("AP"));
        this.FVermoegen = Integer.parseInt(_vals.get("VERMOEGEN"));
    }

    public DSA1Held(File _inFile) {
        HashMap<String, String> charValues = new HashMap<String, String>();
        try {
            Scanner myReader = new Scanner(_inFile);
            while (myReader.hasNextLine()) {
                String line = myReader.nextLine();
                String[] rawvalues = line.split(";");
                String thisKey = rawvalues[0];
                String thisItemText = rawvalues[1];
                charValues.put(thisKey, thisItemText);
            }
            myReader.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("Error reading Adventure file:");
            e.printStackTrace();
        }
        this.initHero(charValues);
    }

    public void saveHero(String _fileName) {
        try {
            FileWriter writer = new FileWriter(_fileName, false);
            writer.write(String.format("%s;%s;\r\n", "NAME", this.getName()));
            writer.write(String.format("%s;%s;\r\n", "TYPUS", this.getTyp()));
            writer.write(String.format("%s;%d;\r\n", "MU", this.getMU()));
            writer.write(String.format("%s;%d;\r\n", "KL", this.getKL()));
            writer.write(String.format("%s;%d;\r\n", "CH", this.getCH()));
            writer.write(String.format("%s;%d;\r\n", "GE", this.getGE()));
            writer.write(String.format("%s;%d;\r\n", "KK", this.getKK()));
            writer.write(String.format("%s;%d;\r\n", "AT", this.getAttake()));
            writer.write(String.format("%s;%d;\r\n", "PA", this.getParade()));
            writer.write(String.format("%s;%d;\r\n", "LE", this.getLebensenergie()));
            writer.write(String.format("%s;%s;\r\n", "TREFFER", this.getTTypName()));
            writer.write(String.format("%s;%d;\r\n", "TBONUS", this.getTFix()));
            writer.write(String.format("%s;%d;\r\n", "RS", this.getRuestung()));
            writer.write(String.format("%s;%d;in Silbertalern\r\n", "VERMOEGEN", this.getVermoegen()));
            writer.write(String.format("%s;%d;\r\n", "AP", this.getAP()));
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ATResult doAttake() {
        int atWert = this.dice().getW20Wurf();
        return new ATResult(atWert <= this.getAttake(), atWert <= 2);
    }

    public void addAP(int _ap) {
        this.AP += _ap;
    }

    public void addSilbertaler(int _st) {
        this.FVermoegen += _st;
    }

    public void addDukaten(int _dk) {
        this.FVermoegen += _dk * 10;
    }

    public void verliereSilbertaler(int _st) {
        this.FVermoegen -= _st;
        if (this.FVermoegen < 0) {
            this.FVermoegen = 0;
        }
    }

    public void verliereDukaten(int _dk) {
        this.FVermoegen -= _dk * 10;
        if (this.FVermoegen < 0) {
            this.FVermoegen = 0;
        }
    }

    public boolean bezahleSilbertaler(int _st) {
        if (this.FVermoegen >= _st) {
            this.FVermoegen -= _st;
            return true;
        }
        return false;
    }

    public boolean bezahleDukaten(int _dk) {
        if (this.FVermoegen >= _dk * 10) {
            this.FVermoegen -= _dk * 10;
            return true;
        }
        return false;
    }

    public boolean doMUprobe(int _mod) {
        return this.dice().getW20Wurf() + _mod <= this.getMU();
    }

    public boolean doKLprobe(int _mod) {
        return this.dice().getW20Wurf() + _mod <= this.getKL();
    }

    public boolean doCHprobe(int _mod) {
        return this.dice().getW20Wurf() + _mod <= this.getCH();
    }

    public boolean doGEprobe(int _mod) {
        return this.dice().getW20Wurf() + _mod <= this.getGE();
    }

    public boolean doKKprobe(int _mod) {
        return this.dice().getW20Wurf() + _mod <= this.getKK();
    }

    public int getKL() {
        return this.KL;
    }

    public int getCH() {
        return this.CH;
    }

    public int getGE() {
        return this.GE;
    }

    public int getKK() {
        return this.KK;
    }

    public int getAP() {
        return this.AP;
    }

    public int getVermoegen() {
        return this.FVermoegen;
    }

    public String getTyp() {
        return this.FTyp;
    }

    @Override
    public String getSummary() {
        return String.format("%s Typ: %s LE(%d), MU(%d), KL(%d), CH(%d), GE(%d), KK(%d), AT(%d), PA(%d), Trefferpunkte(%s), RS(%d), Verm\u00f6gen(%d Silbertaler), AP(%d)", this.getName(), this.getTyp(), this.getLebensenergie(), this.getMU(), this.getKL(), this.getCH(), this.getGE(), this.getKK(), this.getAttake(), this.getParade(), this.getTreffer(), this.getRuestung(), this.getVermoegen(), this.getAP());
    }

    public int receiveAP(int _ap) {
        this.AP += _ap;
        return this.AP;
    }

    private int getHeroKKBonus() {
        if (this.KK > 12) {
            return this.KK - 12;
        }
        if (this.KK < 9) {
            return this.KK - 9;
        }
        return 0;
    }

    public void nimmNeueWaffe(int _tpType, int _tpBonus) {
        this.setTreffer(_tpType, _tpBonus + this.getHeroKKBonus());
    }

    public void collectItem(String _key, String _desc) {
        if (!this.FCollectedItems.containsKey(_key)) {
            this.FCollectedItems.put(_key, _desc);
        }
    }

    public void collectEvent(String _key, String _desc) {
        if (!this.FCollectedEvents.containsKey(_key)) {
            this.FCollectedEvents.put(_key, _desc);
        }
    }

    public boolean hasItem(String _key) {
        return this.FCollectedItems.containsKey(_key);
    }

    public boolean hasEvent(String _key) {
        return this.FCollectedEvents.containsKey(_key);
    }

    public String getInventory() {
        return this.FCollectedItems.values().toString();
    }
}

