/*
 * Decompiled with CFR 0.152.
 */
package de.sanchofock.dsa.adventure;

import de.sanchofock.dsa.Play;
import de.sanchofock.dsa.adventure.items.ItemFactory;
import de.sanchofock.dsa.adventure.items.SAItem;
import de.sanchofock.dsa.character.CharacterGroup;
import de.sanchofock.dsa.character.DSA1Held;
import de.sanchofock.dsa.character.DSACharacter;
import de.sanchofock.dsa.exceptions.ErrorReadingOptions;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;

public class SoloAdventure {
    private HashMap<String, SAItem> FAdvItems = null;
    private CharacterGroup FHero = new CharacterGroup();
    private boolean FReadComplete = false;
    private boolean FIsConstistant = false;

    private String[] extractOptionsArray(String[] _rawValues) {
        String[] result = new String[_rawValues.length - 2];
        int i = 0;
        while (i < result.length) {
            result[i] = _rawValues[i + 2];
            ++i;
        }
        return result;
    }

    private void checkConsitency() {
        String thiskey;
        boolean foundError = false;
        for (Map.Entry<String, SAItem> entry : this.FAdvItems.entrySet()) {
            thiskey = entry.getKey();
            SAItem thisItem = entry.getValue();
            String[] gotos = thisItem.getOptions().getOptionKeys();
            if (thisItem.isActionItem()) {
                gotos = thisItem.getOptions().getOptionsTexts();
            }
            int i = 0;
            while (i < gotos.length) {
                if (!"FIN".equals(gotos[i]) && !this.FAdvItems.containsKey(gotos[i])) {
                    foundError = true;
                    String msg = String.format("ERROR: Im Abschnitt %s: Die Option (%s) ist nicht enthalten", thiskey, gotos[i]);
                    Play.log.logMessage(msg);
                }
                ++i;
            }
        }
        this.FIsConstistant = !foundError;
        for (Map.Entry<String, SAItem> entry : this.FAdvItems.entrySet()) {
            thiskey = entry.getKey();
            if (!(!"1".equals(thiskey) & !this.searchOption(thiskey))) continue;
            String msg = String.format("WARNING: Der Abschnitt %s wird niemals verwendet", thiskey);
            Play.log.logMessage(msg);
        }
    }

    private boolean searchOption(String _key) {
        for (Map.Entry<String, SAItem> entry : this.FAdvItems.entrySet()) {
            SAItem thisItem = entry.getValue();
            String[] gotos = thisItem.getOptions().getOptionKeys();
            if (thisItem.isActionItem()) {
                gotos = thisItem.getOptions().getOptionsTexts();
            }
            int i = 0;
            while (i < gotos.length) {
                if (_key.equals(gotos[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void readHero(File _heroFile) {
        DSA1Held hero = new DSA1Held(_heroFile);
        this.FHero.addCharacter(hero);
        Play.log.logMessage("Character geladen");
        Play.log.logCharStat(hero);
    }

    public void saveHero(String _fileName) {
        ((DSA1Held)this.FHero.getCharacter(0)).saveHero(_fileName);
    }

    public void readAdventureFile(File _inFile) {
        String line = "";
        this.FAdvItems = new HashMap();
        try {
            Scanner myReader = new Scanner(_inFile);
            while (myReader.hasNextLine()) {
                line = myReader.nextLine();
                String[] rawvalues = line.split("\t");
                String thisKey = rawvalues[0];
                if (thisKey == null || "".equals(thisKey)) continue;
                String thisItemText = rawvalues[1];
                String[] thisOptions = this.extractOptionsArray(rawvalues);
                SAItem newItem = ItemFactory.createItem(thisKey, thisItemText, thisOptions);
                this.FAdvItems.put(thisKey, newItem);
            }
            myReader.close();
            this.FReadComplete = true;
            this.checkConsitency();
        }
        catch (FileNotFoundException e) {
            System.out.println("Error reading Adventure file: IO Error");
            e.printStackTrace();
        }
        catch (ErrorReadingOptions e) {
            System.out.println("Error reading Adventure file: Integrity Error");
            System.out.println("Could not parse Options");
            System.out.println("Line: " + line);
            e.printStackTrace();
        }
    }

    public void saveAdventureText(String _outFileName) {
        System.out.print("Writing Adventure Text to: " + _outFileName + " ... ");
        try {
            FileWriter writer = new FileWriter(_outFileName, false);
            for (Map.Entry<String, SAItem> entry : this.FAdvItems.entrySet()) {
                SAItem thisItem = entry.getValue();
                if (thisItem == null) continue;
                writer.write(thisItem.getItemText());
                writer.write("\r\n");
            }
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("DONE");
    }

    public SAItem getFirstItem() {
        return this.FAdvItems.get("1");
    }

    public SAItem getItem(String _key) {
        return this.FAdvItems.get(_key);
    }

    public DSACharacter getHero() {
        return this.FHero.getCharacter(0);
    }

    public boolean readyToPlay() {
        return this.FIsConstistant && this.FReadComplete && this.FAdvItems != null && this.FHero.getSize() > 0;
    }
}

