/*
 * Decompiled with CFR 0.152.
 */
package de.sanchofock.dsa.adventure;

import de.sanchofock.dsa.adventure.ItemOption;
import de.sanchofock.dsa.exceptions.ErrorReadingOptions;
import java.util.ArrayList;
import java.util.HashMap;

public class OptionSet {
    private HashMap<String, ItemOption> FOptions = null;
    private ArrayList<String> FIndex = null;

    private void init() {
        this.FOptions = new HashMap();
        this.FIndex = new ArrayList();
    }

    private void loadOptions(String[] _myOptions) throws ErrorReadingOptions {
        String thisKey = null;
        String thisOptionText = null;
        ItemOption thisNewOption = null;
        try {
            int i = 0;
            while (i < _myOptions.length) {
                thisKey = _myOptions[i];
                thisOptionText = _myOptions[i + 1];
                if (thisKey != null && !"".equals(thisKey)) {
                    thisNewOption = new ItemOption(thisKey, thisOptionText);
                    this.FOptions.put(thisKey, thisNewOption);
                    this.FIndex.add(thisKey);
                }
                i += 2;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ErrorReadingOptions(_myOptions);
        }
    }

    public OptionSet(String[] _rawOption) throws ErrorReadingOptions {
        this.init();
        this.loadOptions(_rawOption);
    }

    public ItemOption getItemOption(String _key) {
        return this.FOptions.get(_key);
    }

    public String[] getOptionKeys() {
        String[] result = new String[this.FIndex.size()];
        int i = 0;
        while (i < this.FIndex.size()) {
            result[i] = this.FIndex.get(i);
            ++i;
        }
        return result;
    }

    public String[] getOptionsTexts() {
        String[] result = new String[this.FIndex.size()];
        int i = 0;
        while (i < this.FIndex.size()) {
            result[i] = this.FOptions.get(this.FIndex.get(i)).getText();
            ++i;
        }
        return result;
    }

    public String getOptionText() {
        String result = "Du kannst: ";
        int i = 0;
        while (i < this.FIndex.size()) {
            result = String.valueOf(result) + this.FOptions.get(this.FIndex.get(i)).getOptionText();
            if (i < this.FIndex.size() - 1) {
                result = String.valueOf(result) + " oder ";
            }
            ++i;
        }
        return result;
    }

    public boolean canGoTo(String _key) {
        return this.FOptions.containsKey(_key);
    }
}

